/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.workflow.compatibility;

import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype = false, label = "WorkItem Adapter Factory", description = "Adapts different types of workitems")
@Properties({
        @Property(name = "service.description", value="Adapts different types of workitemsn"),
        @Property(name = "adapter.condition", value="All Granite WorkItems can be adapted to CQ WorkItems")
})
@Service(value = {AdapterFactory.class, WorkItemAdapterFactory.class})
public class WorkItemAdapterFactory implements AdapterFactory {
    /** The default logger */
    private static Logger log = LoggerFactory.getLogger(WorkItemAdapterFactory.class);

    // ----< public configuration values >--------------------------------------

    @Property(name="adapters", propertyPrivate = true)
    @SuppressWarnings({"UnusedDeclaration"})
    private static final String[] ADAPTER_CLASSES = {
            WorkItem.class.getName()
    };

    @Property(name="adaptables", propertyPrivate = true)
    @SuppressWarnings({"UnusedDeclaration"})
    private static final String[] ADAPTABLE_CLASSES = {
            com.adobe.granite.workflow.exec.WorkItem.class.getName()
    };


    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (WorkItem.class == type && adaptable instanceof com.adobe.granite.workflow.exec.WorkItem) {
            return (AdapterType)new CQWorkItemWrapper((com.adobe.granite.workflow.exec.WorkItem)adaptable);
        }
        return null;
    }
}
