/*
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.util.diff;

import java.io.PrintWriter;

/**
 */
public class InlineChangeListener implements ChangeListener {

    private final PrintWriter out;

    public InlineChangeListener(PrintWriter out) {
        this.out = out;
    }

    public void onDocumentsStart(Document left, Document right) {
        // ignore
    }

    public void onDocumentsEnd(Document left, Document right) {
        out.flush();
    }

    public void onChangeStart(int leftLine, int leftLen, int rightLine, int rightLen) {
        // ignore
    }

    public void onChangeEnd() {
        out.flush();
    }

    public void onUnmodified(int leftLine, int rightLine, Document.Element text) {
        out.print(text);
    }

    public void onDeleted(int leftLine, int rightLine, Document.Element text) {
        String author = null;
        if (text instanceof Document.AnnotatedElement) {
            Document.AnnotatedElement t = (Document.AnnotatedElement) text;
            if (t.getDocumentSource() instanceof DefaultDocumentSource) {
                DefaultDocumentSource src = (DefaultDocumentSource) t.getDocumentSource();
                author = src.getAuthor();
            }
        }
        out.print("<del");
        if (author != null) {
            out.print(" title=\"");
            out.print(author);
            out.print("\"");
        }
        out.print(">");
        out.print(text);
        out.print("</del>");
    }

    public void onInserted(int leftLine, int rightLine, Document.Element text) {
        String author = null;
        if (text instanceof Document.AnnotatedElement) {
            Document.AnnotatedElement t = (Document.AnnotatedElement) text;
            if (t.getDocumentSource() instanceof DefaultDocumentSource) {
                DefaultDocumentSource src = (DefaultDocumentSource) t.getDocumentSource();
                author = src.getAuthor();
            }
        }
        out.print("<ins");
        if (author != null) {
            out.print(" title=\"");
            out.print(author);
            out.print("\"");
        }
        out.print(">");
        out.print(text);
        out.print("</ins>");
    }
}
