/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.taskmanagement;

import org.osgi.service.event.Event;

import java.util.Map;

/**
 * TaskManagement Event
 */
public class TaskEvent extends Event {
    /**
     * Topic for Task Events
     */
    public static final String TOPIC = "com/adobe/granite/taskmanagement/event";

    /**
     * The Id of the task associated with this event.
     */
    public static final String TASK_ID = "TaskId";

    /**
     * The tasktype name of the task associated with this event.
     */
    public static final String TASK_TYPE_NAME = "TaskTypeName";

    /**
	 * The event property name for the type of the event.
     * The value can be one of the following:
	 * <ul>
	 * <li>{@link TaskEventType#TASK_CREATED}
	 * <li>{@link TaskEventType#TASK_SAVED}
	 * <li>{@link TaskEventType#TASK_DELETED}
	 * <li>{@link TaskEventType#TASK_COMPLETED}
	 * <li>{@link TaskEventType#TASK_ARCHIVED}
	 * </ul>
	 */
    public static final String TASK_EVENT_TYPE = "EventType";

    /**
     * The event property name for the name of the type of event.
     */
    public static final String TASK_EVENT_TYPE_STRING = "EventTypeString";

    public TaskEvent(Map<String, Object> properties) {
        super(TaskEvent.TOPIC, properties);
    }

    /**
     * Helper to return the task event type for this event
     * @return the task event type
     */
    public TaskEventType getEventType(){
        return (TaskEventType) getProperty(TASK_EVENT_TYPE);
    }

    /**
     * Helper to return the task id for this task event.
     * @return the Id of the task associated with this event.
     */
    public String getTaskId(){
        return (String) getProperty(TASK_ID);
    }

    /**
     * Helper to return the task type for this task
     * @return task type string
     */
    public String getTaskType(){
        return (String) getProperty(TASK_TYPE_NAME);
    }
}
