/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.payload;

import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.granite.workflow.exec.InboxItem;

import org.osgi.annotation.versioning.ProviderType;

/**
 * PayloadInfoBuilderContext provides the necessary contextual information to the {@link PayloadInfoBuilder} for it
 * to be able to do its job.
 */
@ProviderType
public interface PayloadInfoBuilderContext {

    /**
     * The initiator hint provides information on where the call into the PayloadInfoBuilder was originated.
     * WORKFLOW_CONSOLE: The legacy workflow console.
     * TOUCH_WORKFLOW_CONSOLE: The touch UI workflow console
     * INBOX: The legacy inbox
     * TOUCH_INBOX: The touch UI inbox
     * BADGE:  The inbox's badge
     * NOTIFICATION:  A notification builder (ie: email)
     */
    public enum INITIATOR_HINT {
        WORKFLOW_CONSOLE, TOUCH_WORKFLOW_CONSOLE, INBOX, TOUCH_INBOX, BADGE, NOTIFICATION
    }

    /**
     * Instanciate a {@link PayloadInfo}.
     * @return An empty PayloadInfo
     */
    PayloadInfo createPayloadInfo();

    /**
     * Return the initiator of the call into the PayloadInfoBuilder.
     * @return The initiator.
     * @see com.adobe.granite.workflow.payload.PayloadInfoBuilderContext.INITIATOR_HINT
     */
    String getInitiatorHint();

    /**
     * Specify who initiated the call into the PayloadInfoBuilder.
     * @param initiatorHint The initiator
     * @see com.adobe.granite.workflow.payload.PayloadInfoBuilderContext.INITIATOR_HINT
     */
    void setInitiatorHint(String initiatorHint);

    /**
     * Return the {@link InboxItem} to get the PayloadInfo for.
     * @return The InboxItem
     */
    InboxItem getInboxItem();

    /**
     * Set the {@link InboxItem} to get the PayloadInfo for.
     * @param inboxItem the inbox item
     */
    void setInboxItem(InboxItem inboxItem);

    /**
     * The {@link ResourceResolver} available for use by the PayloadInfoBuilder.
     * @return The ResourceResolver
     */
    ResourceResolver getResourceResolver();

    /**
     * Set the {@link ResourceResolver} to be used by the PayloadInfoBuilder.
     * @param resolver The resolver
     */
    void setResourceResolver(ResourceResolver resolver);

    /**
     * The payload path to use if there is no InboxItem.
     * @return The payload path
     */
    String getPayloadPath();

    /**
     * Set the payload path to use when there is no InboxItem.
     * @param payloadPath The payload path
     */
    void setPayloadPath(String payloadPath);
}
