/*******************************************************************************
 * ADOBE CONFIDENTIAL
 *  __________________
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget;

import java.util.ArrayList;
import java.util.List;

/**
 * A request object used to retrieve a list of offers from Adobe Target.
 * This  class is currently a no-op, but it will be upgraded to support filtering when the Target API
 * offers will support this
 */
public class ListOffersRequest {

    private boolean includeContent;

    private List<ListFilter> filters = new ArrayList<ListFilter>();

    private ListSorter sorter;


    /**
     * Constructs a {@link ListOffersRequest} using the default values (includeContent is false)
     */
    public ListOffersRequest() {
        this.includeContent = false;
    }

    /**
     * Sets the includeContent flag on this request
     *
     * @param include if set to true, the response object(s) will also include the content of the offers, otherwise they won't
     * @return the current {@link ListOffersRequest} object
     */
    public ListOffersRequest includeContent(boolean include) {
        this.includeContent = include;
        return this;
    }

    /**
     * Returns true if this offers request has been instructed to also retrieve the offer's content
     * @return true if the includeContent flag is set, false otherwise.
     */
    public boolean includeContent() {
        return includeContent;
    }

    /**
     * Adds a filter to this requests filter list.
     * This filter is used to generate a query string that searches for specific offers
     * @param filter a {@link ListFilter} object
     * @return a reference to this object
     */
    public ListOffersRequest withFilter(ListFilter filter) {
        filters.add(filter);
        return this;
    }

    /**
     * Adds a sorter to this request.
     * This sorter is used to generate the "sortBy" element of the query string
     * @param sorter a {@link ListSorter} object
     * @return an instance to this object
     */
    public ListOffersRequest withSorter(ListSorter sorter) {
        this.sorter = sorter;
        return this;
    }

    /**
     * Retrieves the list of filters of this request object
     * @return a list of {@link ListFilter} objects
     */
    public List<ListFilter> getFilters() {
        return this.filters;
    }

    /**
     * Returns the sorter for this list
     * @return a {@link ListSorter} object
     */
    public ListSorter getSorter() {
        return this.sorter;
    }
}

