/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting.helpers;

/**
 * This class provides several constants to be used in the context of reporting.
 */
public class Const {

    private Const() {
        // static access only
    }


    // nodes and properties, column --------------------------------------------------------

    /**
     * Name of the property that defines a column's aggregate type by default
     */
    public static final String PN_AGGREGATE = "aggregate";

    /**
     * Name of the property that defines a column's value type
     */
    public static final String PN_TYPE = "type";

    /**
     * Name of the property that defines if a column is grouped
     */
    public static final String PN_IS_GROUPED = "grouped";

    /**
     * Name of the property that determines the class of a report
     */
    public static final String PN_REPORT_CLASS = "reportClass";

    /**
     * Name of the property that determines the root path of a report's data
     */
    public static final String PN_DATA_ROOT = "rootPath";

    /**
     * Name of the property that determines the custom root path of a report's data
     */
    public static final String PN_DATA_CUSTOM_ROOT = "customPath";

    /**
     * Name of the property that determines the path flatness of a report
     */
    public static final String PN_DATA_FLATNESS = "pathFlatness";

    /**
     * Name of the property that defines the subpath to get the data from
     */
    public static final String PN_VALUE_SUBPATH = "subPath";

    /**
     * Name of the property that defines the property name(s) to get the data from
     */
    public static final String PN_VALUE_PROPERTY = "property";

    /**
     * Name of the property that defines the subpath to get the data from
     */
    public static final String PN_SECONDARY_VALUE_SUBPATH = "secondarySubPath";

    /**
     * Name of the property that defines the property name(s) to get secondary data from
     */
    public static final String PN_SECONDARY_VALUE_PROPERTY = "secondaryProperty";

    /**
     * Name of the property that defines if the column is groupable
     */
    public static final String PN_IS_GROUPABLE = "groupable";

    /**
     * Name of the property that defines a resolver to be used for the column's values.
     */
    public static final String PN_RESOLVER = "resolver";

    /**
     * Name of the node that may contain additional resolver configuration
     */
    public static final String NN_RESOLVER_CONFIG = "resolverConfig";

    /**
     * Name of the property that may contain a path used by a resolver
     */
    public static final String PN_RESOLVER_PATH = "path";

    /**
     * Name of the property that may contain a property name used by a resolver
     */
    public static final String PN_RESOLVER_PROPERTY_NAME = "propertyName";

    /**
     * Name of the property that may contain a sub path used by a resolver
     */
    public static final String PN_RESOLVER_SUB_PATH = "subPath";

    /**
     * Name of the property that may define if a resolved value has to be internationalized
     */
    public static final String PN_RESOLVER_I18N = "i18n";

    /**
     * path from a column's setting to the sorting subnode
     */
    public static final String NN_COL_SORTING = "sorting";

    /**
     * Name of the property that determines if a column is sorted
     */
    public static final String PN_COL_ISSORTED = "sorted";

    /**
     * Name of the property that determines the sorting direction (if sorted) of a column
     */
    public static final String PN_COL_SORTDIR = "direction";

    /**
     * Name of the node that contains the columns of a report (relative to the report's
     * component node)
     */
    public static final String NN_COLUMNS = "columns";

    /**
     * Name of the node that contains column definitions (used by the column's component
     * node)
     */
    public static final String NN_COLDEFS = "definitions";

    /**
     * Name of the node that contains the default settings of a column (used by the
     * column's component node)
     */
    public static final String NN_DEFAULTS = "defaults";

    /**
     * Name of the node that contains the column settings (used by the column's instance
     * node)
     */
    public static final String NN_SETTINGS = "settings";

    /**
     * Name of generic config node
     */
    public static final String NN_GENERIC = "generic";

    /**
     * Name of query builder-related config nodes
     */
    public static final String NN_QUERYBUILDER = "queryBuilder";

    /**
     * Name of the root node for filter configuration/definition
     */
    public static final String NN_FILTERS = "filters";

    /**
     * Name of the root node for data-related configuration
     */
    public static final String NN_DATA = "data";

    /**
     * Name of the root node for data preprocessing definitions
     */
    public static final String NN_PREPROCESSING = "preprocessing";

    /**
     * Name of the node that defines property constraints
     */
    public static final String NN_PROP_CONSTRAINTS = "propertyConstraints";

    /**
     * Name of properties that define a property name
     */
    public static final String PN_PROPNAME = "name";

    /**
     * Name of properties that define a property value
     */
    public static final String PN_PROPVALUE = "value";

    /**
     * Name of the property that defines the node types to be included in result sets
     */
    public static final String PN_NODETYPES = "nodeTypes";

    /**
     * Name of the property that defines if tree traversal be done instead of query for result sets
     */
    public static final String PN_TREETRAVERSAL = "treeTraversal";

    /**
     * Name of the property that defines properties that are required for a node to be
     * included in result sets
     */
    public static final String PN_MANDATORY_PROPS = "mandatoryProperties";

    /**
     * Name of the property that defines a filter's ID (used for internal referencing
     */
    public static final String PN_FILTER_ID = "id";

    /**
     * Name of the property that defines a filter's type
     */
    public static final String PN_FILTER_TYPE = "filterType";

    /**
     * Name of the property that defines the phase the filter is bound to
     */
    public static final String PN_FILTERING_PHASE = "phase";

    /**
     * Name of the property that defines if a filter is active
     */
    public static final String PN_FILTER_ACTIVE = "active";

    /**
     * Name of the property that defines the filter value (format is specific for the
     * implementing filter)
     */
    public static final String PN_FILTER_VALUE = "value";

    /**
     * Name of the property that contains the regex pattern for a data preprocessor
     */
    public static final String PN_DPP_REGEX_PATTERN = "pattern";

    /**
     * Name of the property that contains the replace string/pattern for a data preprocessor
     */
    public static final String PN_DPP_REGEX_REPLACE = "replace";

    /**
     * Name of the property that contains the data format for a data preprocessor
     */
    public static final String PN_DPP_FORMAT = "format";

    /**
     * Name of the sub-node that contains the data processor for aggregated state
     */
    public static final String NN_DPP_AGGREGATED = "aggregated";


    // nodes and properties, report --------------------------------------------------------

    /**
     * Name of the property (on the report node) that defines the current server processing
     * mode
     */
    public static final String PN_SERVER_PROCMODE = "processing";

    /**
     * Name of the property (on the report node) that defines the current snapshot mode
     * of the report
     */
    public static final String PN_SNAPSHOTS = "snapshots";

    /**
     * Name of the property (on the report node) that holds the path of the versioned report
     * node that contains the definition snapshots are currently taken for
     */
    public static final String PN_SNAPSHOT_REPORT_PATH = "snapshotReportPath";

    /**
     * Name of the property (on the report node) that holds a unique identifier to
     * separate the different versions of a report
     */
    public static final String PN_SNAPSHOT_REPORT_DATAID = "snapshotDataId";

    /**
     * Name of the property (on the report node) that holds the version of reporting the
     * report was created for
     */
    public static final String PN_REPORTING_VERSION = "repVersion";

    /**
     * Name of the property (on finished report nodes) that defines the user to be used for
     * taking snapshots
     */
    public static final String PN_SNAPSHOT_RUNNER = "snapshotRunner";


    // node and properties, snapshots ------------------------------------------------------

    /**
     * Node name: Snapshot data
     */
    public static final String NN_SNAPSHOT_DATA = "data";

    /**
     * Node name: Type info for snapshot
     */
    public static final String NN_SNAPSHOT_TYPEINFO = "typeInfo";

    /**
     * Node name: Totals for data columns of a snapshot
     */
    public static final String NN_SNAPSHOT_TOTALS = "totals";

    /**
     * Property name: Time of a snapshot
     */
    public static final String PN_SNAPSHOT_TIME = "snapshotTime";

    /**
     * Property name: Grouped column names (type info)
     */
    public static final String PN_SNAPSHOT_GROUPED_COLS = "groupedCols";

    /**
     * Property name: Grouped column types (type info)
     */
    public static final String PN_SNAPSHOT_GROUPED_TYPES = "groupedTypes";

    /**
     * Property name: Grouped column titles (type info)
     */
    public static final String PN_SNAPSHOT_GROUPED_TITLES = "groupedTitles";

    /**
     * Property name: Data column names (type info)
     */
    public static final String PN_SNAPSHOT_DATA_COLS = "dataCols";

    /**
     * Property name: Data column types (type info)
     */
    public static final String PN_SNAPSHOT_DATA_TYPES = "dataTypes";

    /**
     * Property name: Data column titles (type info)
     */
    public static final String PN_SNAPSHOT_DATA_TITLES = "dataTitles";

    /**
     * Property name: Data column sorting (type info)
     */
    public static final String PN_SNAPSHOT_DATA_SORTING = "dataSorting";

    /**
     * Property name: Flag if snapshot contains grouped columns; <code>false</code>, if
     * no data is available
     */
    public static final String PN_SNAPSHOT_HAS_GROUPED_COLS = "hasGroupedColumns";


    // paths -------------------------------------------------------------------------------

    /**
     * Path to a report's query builder settings
     */
    public static final String PATH_REP_QUERYBUILDER = Const.NN_QUERYBUILDER;

    /**
     * Path to a column component's query builder settings
     */
    public static final String PATH_COL_QUERYBUILDER = Const.NN_COLDEFS + "/"
            + Const.NN_QUERYBUILDER;

    /**
     * Path to a column component's filter settings
     */
    public static final String PATH_COL_FILTERS = Const.NN_COLDEFS + "/"
            + Const.NN_FILTERS;

    /**
     * Path to a column component's data settings
     */
    public static final String PATH_DATA = Const.NN_COLDEFS + "/" + Const.NN_DATA;

    /**
     * Path to a column's preprocessing data configuration
     */
    public static final String PATH_PREPROCESSING = PATH_DATA + "/"
            + Const.NN_PREPROCESSING;


    // "magic values" ----------------------------------------------------------------------

    /**
     * Processing mode: Serverside
     */
    public static final String PMODE_SERVER = "server";

    /**
     * Processing mode: Serverside; interactive mode
     */
    public static final String PMODE_SERVER_INTERACTIVE = "server-interactive";

    /**
     * Selector for rendering the tabular view only
     */
    public static final String RENDER_TYPE_TABULAR = "tabular";

    /**
     * Selector for rendering a chart view only
     */
    public static final String RENDER_TYPE_CHART = "chart";


    // node types --------------------------------------------------------------------------

    /**
     * Node type for frozen reports
     */
    public static final String NT_FROZEN_REPORT = "cq:FrozenReport";


}
