/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import org.apache.felix.scr.annotations.Component;

/**
 * Similarity search using JCR XPath's <code>rep:similar()</code>.
 * 
 * <p>
 * Does not support filtering.
 * Does not support facet extraction.
 *
 * <h3>Name:</h3>
 * similar
 *
 * <h3>Properties:</h3>
 * <dl>
 * <dt>similar</dt><dd>absolute path to the node for which to find similar nodes</dd>
 * <dt>local</dt><dd>a relative path to a descendant node or . for the current node (optional, default is ".")</dd>
 * </dl>
 * 
 * @since 5.2
 */
@Component(metatype = false, factory = "com.day.cq.search.eval.PredicateEvaluator/similar")
public class SimilarityPredicateEvaluator extends AbstractPredicateEvaluator {
    
    public static final String SIMILAR = "similar";
    public static final String LOCAL = "local";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue(SIMILAR)) {
            return null;
        }
        return "rep:similar(" + p.get(LOCAL, ".") + ", '" + p.get(SIMILAR) + "')";
    }

    @Override
    public boolean canXpath(Predicate p, EvaluationContext context) {
        return true;
    }

    @Override
    public boolean canFilter(Predicate p, EvaluationContext context) {
        return false;
    }
    
}
