package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.day.cq.wcm.designimporter.api.ImporterConstants;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.ImageComponentTagHandler;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.Constants;
import org.osgi.service.component.ComponentContext;

/**
 * The TagHandlerFactory that rolls out {@link ImageComponentTagHandler} instances
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = ImageComponentTagHandlerFactory.TAG_PATTERN),
        @Property(name = ImporterConstants.PN_RESOURCE_TYPE, value = ImageComponentTagHandlerFactory.RESOURCE_TYPE_IMAGE)
})
public class ImageComponentTagHandlerFactory implements TagHandlerFactory {

    static protected final String RESOURCE_TYPE_IMAGE = "foundation/components/image";

    static public final String TAG_PATTERN = "<(div|span|img)(?=.* data-cq-component=\"(?i)image\").*>";

    private String resourceType;

    public TagHandler create() {
        ImageComponentTagHandler imageComponentTagHandler = new ImageComponentTagHandler();
        imageComponentTagHandler.setResourceType(resourceType);
        return imageComponentTagHandler;
    }

    /**
     * The bundle activator method. For internal use.
     * @param context
     */
    @Activate
    protected void activate(ComponentContext context) {
        resourceType = OsgiUtil.toString(context.getProperties().get(ImporterConstants.PN_RESOURCE_TYPE), RESOURCE_TYPE_IMAGE);
    }

}
