/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.emulator;

import org.apache.sling.api.resource.Resource;

import java.util.List;

/**
 * The <code>EmulatorProvider</code> interface specifies emulator providers.
 *
 * @since CQ 5.4.0
 */
public interface EmulatorProvider {


    /**
     * Returns the emulators for the specified resource.
     *
     * @param resource The resource
     * @return The emulators, or an empty list.
     */
    List<Emulator> getEmulators(Resource resource);

    /**
     * Indicates whether this provider handles the specified resource.
     *
     * @param resource The resource
     * @return <code>true</code> if the provider handles the resource,
     *         <code>false</code> otherwise
     */
    boolean handles(Resource resource);

    /**
     * Returns a list of groups containing emulators.
     *
     * @param resource The resource from which to derive the emulator groups.
     * @return A <code>List</code> containing the emulator groups.
     */
    List<EmulatorGroup> getEmulatorGroups(Resource resource);
}
