/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;


/**
 * Object who need to be cleaned up when an <code>ExecutionContext</code>
 * is destroyed, the <code>Finalizer</code> interface may register with the
 * {@link com.day.util.FinalizerHandler}. At the end of the
 * <code>ExecutionContext</code>, all registered <code>Finalizer</code>
 * instances are called for their cleanup work.
 *
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author fmeschbe
 * @since antbear
 */
public interface Finalizer {

    /**
     * This is the method called by the {@link com.day.util.FinalizerHandler}
     * when the finalizing work has to be done.
     */
    public void doFinalize();

}
