/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * An <code>IteratorEnumeration</code> provides a one-to-one mapping
 * from the pre Java 2 {@link java.util.Enumeration} to the Java 2
 * {@link java.util.Iterator}
 *
 * @version $Revision: 1.4 $
 * @author dpfister
 * @since antbear
 */
public class IteratorEnumeration implements Enumeration {

    /** Underlying iterator */
    protected Iterator iter;

    /**
     * Create a new <code>IteratorEnumeration</code> given an
     * {@link java.util.Iterator} that backs up the
     * {@link java.util.Enumeration}
     * @param iter the iterator
     */
    public IteratorEnumeration(Iterator iter) {
	this.iter = iter;
    }

    /**
     * Tests if this enumeration contains more elements.
     *
     * @return  <code>true</code> if and only if this enumeration object
     *           contains at least one more element to provide;
     *          <code>false</code> otherwise.
     */
    public boolean hasMoreElements() {
	return iter.hasNext();
    }

    /**
     * Returns the next element of this enumeration if this enumeration
     * object has at least one more element to provide.
     *
     * @return     the next element of this enumeration.
     */
    public Object nextElement() {
	return iter.next();
    }
}
