/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.lang;

import com.adobe.agl.impl.NormalizerImpl;
import com.adobe.agl.impl.UBiDiProps;
import com.adobe.agl.impl.UCaseProps;
import com.adobe.agl.impl.UCharacterName;
import com.adobe.agl.impl.UCharacterProperty;
import com.adobe.agl.impl.UCharacterUtility;
import com.adobe.agl.impl.UPropertyAliases;
import com.adobe.agl.lang.UCharacterEnums;
import com.adobe.agl.lang.UCharacterTypeIterator;
import com.adobe.agl.lang.UScript;
import com.adobe.agl.text.BreakIterator;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.util.RangeValueIterator;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.VersionInfo;
import java.io.IOException;
import java.util.MissingResourceException;

public final class UCharacter
implements UCharacterEnums.ECharacterCategory,
UCharacterEnums.ECharacterDirection {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int REPLACEMENT_CHAR = 65533;
    public static final double NO_NUMERIC_VALUE = -1.23456789E8;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final int TITLECASE_NO_LOWERCASE = 256;
    public static final int TITLECASE_NO_BREAK_ADJUSTMENT = 512;
    public static final int FOLD_CASE_DEFAULT = 0;
    public static final int FOLD_CASE_EXCLUDE_SPECIAL_I = 1;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int MIN_CODE_POINT = 0;
    static UCharacterName NAME_;
    static UPropertyAliases PNAMES_;
    private static final UCharacterProperty PROPERTY_;
    private static final char[] PROPERTY_TRIE_INDEX_;
    private static final char[] PROPERTY_TRIE_DATA_;
    private static final int PROPERTY_INITIAL_VALUE_;
    private static final UCaseProps gCsp;
    private static final UBiDiProps gBdp;

    public static int digit(int ch, int radix) {
        int props = UCharacter.getProperty(ch);
        int value = UCharacter.getNumericType(props) == 1 ? UCharacterProperty.getUnsignedValue(props) : UCharacter.getEuropeanDigit(ch);
        return 0 <= value && value < radix ? value : -1;
    }

    public static int digit(int ch) {
        int props = UCharacter.getProperty(ch);
        if (UCharacter.getNumericType(props) == 1) {
            return UCharacterProperty.getUnsignedValue(props);
        }
        return -1;
    }

    public static double getUnicodeNumericValue(int ch) {
        int props = PROPERTY_.getProperty(ch);
        int numericType = UCharacter.getNumericType(props);
        if (numericType == 0 || numericType >= 6) {
            return -1.23456789E8;
        }
        int numericValue = UCharacterProperty.getUnsignedValue(props);
        if (numericType < 4) {
            return numericValue;
        }
        if (numericType == 4) {
            int numerator = numericValue >> 3;
            int denominator = (numericValue & 7) + 2;
            if (numerator == 0) {
                numerator = -1;
            }
            return (double)numerator / (double)denominator;
        }
        int mant = numericValue >> 4;
        int exp = numericValue & 0xF;
        if (mant == 0) {
            mant = 1;
            exp += 18;
        } else {
            if (mant > 9) {
                return -1.23456789E8;
            }
            exp += 2;
        }
        double numValue = mant;
        while (exp >= 4) {
            numValue *= 10000.0;
            exp -= 4;
        }
        switch (exp) {
            case 3: {
                numValue *= 1000.0;
                break;
            }
            case 2: {
                numValue *= 100.0;
                break;
            }
            case 1: {
                numValue *= 10.0;
                break;
            }
        }
        return numValue;
    }

    public static int getType(int ch) {
        return UCharacter.getProperty(ch) & 0x1F;
    }

    public static boolean isDigit(int ch) {
        return UCharacter.getType(ch) == 9;
    }

    public static boolean isLowerCase(int ch) {
        return UCharacter.getType(ch) == 2;
    }

    public static boolean isWhitespace(int ch) {
        return (1 << UCharacter.getType(ch) & 0x7000) != 0 && ch != 160 && ch != 8239 && ch != 65279 || ch >= 9 && ch <= 13 || ch >= 28 && ch <= 31;
    }

    public static int toLowerCase(int ch) {
        return gCsp.tolower(ch);
    }

    public static String toString(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            return null;
        }
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        StringBuffer result = new StringBuffer();
        result.append(UTF16.getLeadSurrogate(ch));
        result.append(UTF16.getTrailSurrogate(ch));
        return result.toString();
    }

    public static boolean isSupplementary(int ch) {
        return ch >= 65536 && ch <= 0x10FFFF;
    }

    public static boolean isBaseForm(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 9 || cat == 11 || cat == 10 || cat == 1 || cat == 2 || cat == 3 || cat == 4 || cat == 5 || cat == 6 || cat == 7 || cat == 8;
    }

    public static int getDirection(int ch) {
        return gBdp.getClass(ch);
    }

    public static int getMirror(int ch) {
        return gBdp.getMirror(ch);
    }

    public static int getCombiningClass(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return NormalizerImpl.getCombiningClass(ch);
    }

    public static boolean isLegal(int ch) {
        if (ch < 0) {
            return false;
        }
        if (ch < 55296) {
            return true;
        }
        if (ch <= 57343) {
            return false;
        }
        if (UCharacterUtility.isNonCharacter(ch)) {
            return false;
        }
        return ch <= 0x10FFFF;
    }

    public static VersionInfo getUnicodeVersion() {
        return UCharacter.PROPERTY_.m_unicodeVersion_;
    }

    public static int getCharFromName1_0(String name) {
        if (NAME_ == null) {
            throw new MissingResourceException("Could not load unames.icu", "", "");
        }
        return NAME_.getCharFromName(1, name);
    }

    public static int getCharFromExtendedName(String name) {
        if (NAME_ == null) {
            throw new MissingResourceException("Could not load unames.icu", "", "");
        }
        return NAME_.getCharFromName(2, name);
    }

    public static int getPropertyEnum(String propertyAlias) {
        return PNAMES_.getPropertyEnum(propertyAlias);
    }

    public static int getPropertyValueEnum(int property, String valueAlias) {
        return PNAMES_.getPropertyValueEnum(property, valueAlias);
    }

    public static int getCodePoint(char lead, char trail) {
        if (UTF16.isLeadSurrogate(lead) && UTF16.isTrailSurrogate(trail)) {
            return UCharacterProperty.getRawSupplementary(lead, trail);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    public static String toUpperCase(ULocale locale, String str) {
        int c;
        StringContextIterator iter = new StringContextIterator(str);
        StringBuffer result = new StringBuffer(str.length());
        int[] locCache = new int[1];
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        locCache[0] = 0;
        while ((c = iter.nextCaseMapCP()) >= 0) {
            if ((c = gCsp.toFullUpper(c, iter, result, locale, locCache)) < 0) {
                c ^= 0xFFFFFFFF;
            } else if (c <= 31) continue;
            if (c <= 65535) {
                result.append((char)c);
                continue;
            }
            UTF16.append(result, c);
        }
        return result.toString();
    }

    public static String toLowerCase(ULocale locale, String str) {
        int c;
        StringContextIterator iter = new StringContextIterator(str);
        StringBuffer result = new StringBuffer(str.length());
        int[] locCache = new int[1];
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        locCache[0] = 0;
        while ((c = iter.nextCaseMapCP()) >= 0) {
            if ((c = gCsp.toFullLower(c, iter, result, locale, locCache)) < 0) {
                c ^= 0xFFFFFFFF;
            } else if (c <= 31) continue;
            if (c <= 65535) {
                result.append((char)c);
                continue;
            }
            UTF16.append(result, c);
        }
        return result.toString();
    }

    public static String toTitleCase(ULocale locale, String str, BreakIterator titleIter) {
        return UCharacter.toTitleCase(locale, str, titleIter, 0);
    }

    public static String toTitleCase(ULocale locale, String str, BreakIterator titleIter, int options) {
        StringContextIterator iter = new StringContextIterator(str);
        StringBuffer result = new StringBuffer(str.length());
        int[] locCache = new int[1];
        int srcLength = str.length();
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        locCache[0] = 0;
        if (titleIter == null) {
            titleIter = BreakIterator.getWordInstance(locale);
        }
        titleIter.setText(str);
        boolean isDutch = locale.getLanguage().equals("nl");
        boolean FirstIJ = true;
        int prev = 0;
        boolean isFirstIndex = true;
        while (prev < srcLength) {
            int index;
            if (isFirstIndex) {
                isFirstIndex = false;
                index = titleIter.first();
            } else {
                index = titleIter.next();
            }
            if (index == -1 || index > srcLength) {
                index = srcLength;
            }
            if (prev < index) {
                int titleStart;
                iter.setLimit(index);
                int c = iter.nextCaseMapCP();
                if ((options & 0x200) == 0 && 0 == gCsp.getType(c)) {
                    while ((c = iter.nextCaseMapCP()) >= 0 && 0 == gCsp.getType(c)) {
                    }
                    titleStart = iter.getCPStart();
                    if (prev < titleStart) {
                        result.append(str.substring(prev, titleStart));
                    }
                } else {
                    titleStart = prev;
                }
                if (titleStart < index) {
                    FirstIJ = true;
                    c = gCsp.toFullTitle(c, iter, result, locale, locCache);
                    while (true) {
                        if (c < 0) {
                            if ((c ^= 0xFFFFFFFF) <= 65535) {
                                result.append((char)c);
                            } else {
                                UTF16.append(result, c);
                            }
                        } else if (c > 31) {
                            if (c <= 65535) {
                                result.append((char)c);
                            } else {
                                UTF16.append(result, c);
                            }
                        }
                        if ((options & 0x100) != 0) {
                            int titleLimit = iter.getCPLimit();
                            if (titleLimit >= index) continue;
                            String appendStr = str.substring(titleLimit, index);
                            if (isDutch && c == 73 && appendStr.startsWith("j")) {
                                appendStr = "J" + appendStr.substring(1);
                            }
                            result.append(appendStr);
                            iter.moveToLimit();
                            break;
                        }
                        int nc = iter.nextCaseMapCP();
                        if (nc < 0) break;
                        if (isDutch && (nc == 74 || nc == 106) && c == 73 && FirstIJ) {
                            c = 74;
                            FirstIJ = false;
                            continue;
                        }
                        c = gCsp.toFullLower(nc, iter, result, locale, locCache);
                    }
                }
            }
            prev = index;
        }
        return result.toString();
    }

    public static final String foldCase(String str, int options) {
        StringBuffer result = new StringBuffer(str.length());
        int length = str.length();
        int i = 0;
        while (i < length) {
            int c = UTF16.charAt(str, i);
            i += UTF16.getCharCount(c);
            if ((c = gCsp.toFullFolding(c, result, options)) < 0) {
                c ^= 0xFFFFFFFF;
            } else if (c <= 31) continue;
            if (c <= 65535) {
                result.append((char)c);
                continue;
            }
            UTF16.append(result, c);
        }
        return result.toString();
    }

    public static RangeValueIterator getTypeIterator() {
        return new UCharacterTypeIterator(PROPERTY_);
    }

    public static VersionInfo getAge(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.getAge(ch);
    }

    public static boolean hasBinaryProperty(int ch, int property) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.hasBinaryProperty(ch, property);
    }

    public static boolean isUAlphabetic(int ch) {
        return UCharacter.hasBinaryProperty(ch, 0);
    }

    public static boolean isUWhiteSpace(int ch) {
        return UCharacter.hasBinaryProperty(ch, 31);
    }

    public static int getIntPropertyValue(int ch, int type) {
        if (type < 0) {
            return 0;
        }
        if (type < 49) {
            return UCharacter.hasBinaryProperty(ch, type) ? 1 : 0;
        }
        if (type < 4096) {
            return 0;
        }
        if (type < 4117) {
            switch (type) {
                case 4096: {
                    return UCharacter.getDirection(ch);
                }
                case 4097: {
                    return UnicodeBlock.idOf(ch);
                }
                case 4098: {
                    return UCharacter.getCombiningClass(ch);
                }
                case 4099: {
                    return PROPERTY_.getAdditional(ch, 2) & 0x1F;
                }
                case 4100: {
                    return (PROPERTY_.getAdditional(ch, 0) & 0xE0000) >> 17;
                }
                case 4101: {
                    return UCharacter.getType(ch);
                }
                case 4102: {
                    return gBdp.getJoiningGroup(ch);
                }
                case 4103: {
                    return gBdp.getJoiningType(ch);
                }
                case 4104: {
                    return (PROPERTY_.getAdditional(ch, 2) & 0x3F00000) >> 20;
                }
                case 4105: {
                    type = UCharacter.getNumericType(PROPERTY_.getProperty(ch));
                    if (type > 3) {
                        type = 3;
                    }
                    return type;
                }
                case 4106: {
                    return UScript.getScript(ch);
                }
                case 4107: {
                    if (ch >= 4352) {
                        if (ch <= 4607) {
                            if (ch <= 4447) {
                                if (ch == 4447 || ch <= 4441 || UCharacter.getType(ch) == 5) {
                                    return 1;
                                }
                            } else if (ch <= 4519) {
                                if (ch <= 4514 || UCharacter.getType(ch) == 5) {
                                    return 2;
                                }
                            } else if (ch <= 4601 || UCharacter.getType(ch) == 5) {
                                return 3;
                            }
                        } else if ((ch -= 44032) >= 0 && ch < 11172) {
                            return ch % 28 == 0 ? 4 : 5;
                        }
                    }
                    return 0;
                }
                case 4108: 
                case 4109: 
                case 4110: 
                case 4111: {
                    return NormalizerImpl.quickCheck(ch, type - 4108 + 2);
                }
                case 4112: {
                    return NormalizerImpl.getFCD16(ch) >> 8;
                }
                case 4113: {
                    return NormalizerImpl.getFCD16(ch) & 0xFF;
                }
                case 4114: {
                    return (PROPERTY_.getAdditional(ch, 2) & 0x3E0) >> 5;
                }
                case 4115: {
                    return (PROPERTY_.getAdditional(ch, 2) & 0xF8000) >> 15;
                }
                case 4116: {
                    return (PROPERTY_.getAdditional(ch, 2) & 0x7C00) >> 10;
                }
            }
            return 0;
        }
        if (type == 8192) {
            return UCharacterProperty.getMask(UCharacter.getType(ch));
        }
        return 0;
    }

    private UCharacter() {
    }

    private static int getEuropeanDigit(int ch) {
        if (ch > 122 && ch < 65313 || ch < 65 || ch > 90 && ch < 97 || ch > 65370 || ch > 65329 && ch < 65345) {
            return -1;
        }
        if (ch <= 122) {
            return ch + 10 - (ch <= 90 ? 65 : 97);
        }
        if (ch <= 65338) {
            return ch + 10 - 65313;
        }
        return ch + 10 - 65345;
    }

    private static int getNumericType(int props) {
        return (props & 0xE0) >> 5;
    }

    private static final int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[ch >> 5] << 2) + (ch & 0x1F)];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return PROPERTY_INITIAL_VALUE_;
            }
        }
        if (ch <= 56319) {
            return PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[320 + (ch >> 5)] << 2) + (ch & 0x1F)];
        }
        if (ch <= 0x10FFFF) {
            return UCharacter.PROPERTY_.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF));
        }
        return PROPERTY_INITIAL_VALUE_;
    }

    static {
        UBiDiProps bdp;
        UCaseProps csp;
        NAME_ = null;
        PNAMES_ = null;
        try {
            PNAMES_ = new UPropertyAliases();
            NAME_ = UCharacterName.getInstance();
        }
        catch (IOException e) {
            throw new MissingResourceException(e.getMessage(), "", "");
        }
        try {
            PROPERTY_ = UCharacterProperty.getInstance();
            PROPERTY_TRIE_INDEX_ = UCharacter.PROPERTY_.m_trieIndex_;
            PROPERTY_TRIE_DATA_ = UCharacter.PROPERTY_.m_trieData_;
            PROPERTY_INITIAL_VALUE_ = UCharacter.PROPERTY_.m_trieInitialValue_;
        }
        catch (Exception e) {
            throw new MissingResourceException(e.getMessage(), "", "");
        }
        try {
            csp = UCaseProps.getSingleton();
        }
        catch (IOException e) {
            csp = UCaseProps.getDummy();
        }
        gCsp = csp;
        try {
            bdp = UBiDiProps.getSingleton();
        }
        catch (IOException e) {
            bdp = UBiDiProps.getDummy();
        }
        gBdp = bdp;
    }

    private static class StringContextIterator
    implements UCaseProps.ContextIterator {
        protected String s;
        protected int index;
        protected int limit;
        protected int cpStart;
        protected int cpLimit;
        protected int dir;

        StringContextIterator(String s) {
            this.s = s;
            this.limit = s.length();
            this.index = 0;
            this.cpLimit = 0;
            this.cpStart = 0;
            this.dir = 0;
        }

        public void setLimit(int lim) {
            this.limit = 0 <= lim && lim <= this.s.length() ? lim : this.s.length();
        }

        public void moveToLimit() {
            this.cpStart = this.cpLimit = this.limit;
        }

        public int nextCaseMapCP() {
            this.cpStart = this.cpLimit;
            if (this.cpLimit < this.limit) {
                char c2;
                int c;
                if ((55296 <= (c = this.s.charAt(this.cpLimit++)) || c <= 57343) && c <= 56319 && this.cpLimit < this.limit && '\udc00' <= (c2 = this.s.charAt(this.cpLimit)) && c2 <= '\udfff') {
                    ++this.cpLimit;
                    c = UCharacterProperty.getRawSupplementary((char)c, c2);
                }
                return c;
            }
            return -1;
        }

        public int getCPStart() {
            return this.cpStart;
        }

        public int getCPLimit() {
            return this.cpLimit;
        }

        public void reset(int direction) {
            if (direction > 0) {
                this.dir = 1;
                this.index = this.cpLimit;
            } else if (direction < 0) {
                this.dir = -1;
                this.index = this.cpStart;
            } else {
                this.dir = 0;
                this.index = 0;
            }
        }

        public int next() {
            if (this.dir > 0 && this.index < this.s.length()) {
                int c = UTF16.charAt(this.s, this.index);
                this.index += UTF16.getCharCount(c);
                return c;
            }
            if (this.dir < 0 && this.index > 0) {
                int c = UTF16.charAt(this.s, this.index - 1);
                this.index -= UTF16.getCharCount(c);
                return c;
            }
            return -1;
        }
    }

    public static interface JoiningType {
        public static final int NON_JOINING = 0;
        public static final int JOIN_CAUSING = 1;
        public static final int DUAL_JOINING = 2;
        public static final int LEFT_JOINING = 3;
        public static final int RIGHT_JOINING = 4;
        public static final int TRANSPARENT = 5;
        public static final int COUNT = 6;
    }

    public static interface DecompositionType {
        public static final int NONE = 0;
        public static final int CANONICAL = 1;
        public static final int COMPAT = 2;
        public static final int CIRCLE = 3;
        public static final int FINAL = 4;
        public static final int FONT = 5;
        public static final int FRACTION = 6;
        public static final int INITIAL = 7;
        public static final int ISOLATED = 8;
        public static final int MEDIAL = 9;
        public static final int NARROW = 10;
        public static final int NOBREAK = 11;
        public static final int SMALL = 12;
        public static final int SQUARE = 13;
        public static final int SUB = 14;
        public static final int SUPER = 15;
        public static final int VERTICAL = 16;
        public static final int WIDE = 17;
        public static final int COUNT = 18;
    }

    public static final class UnicodeBlock
    extends Character.Subset {
        public static final UnicodeBlock NO_BLOCK = new UnicodeBlock("NO_BLOCK", 0);
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("BASIC_LATIN", 1);
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT", 2);
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A", 3);
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B", 4);
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS", 5);
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS", 6);
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS", 7);
        public static final UnicodeBlock GREEK = new UnicodeBlock("GREEK", 8);
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("CYRILLIC", 9);
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("ARMENIAN", 10);
        public static final UnicodeBlock HEBREW = new UnicodeBlock("HEBREW", 11);
        public static final UnicodeBlock ARABIC = new UnicodeBlock("ARABIC", 12);
        public static final UnicodeBlock SYRIAC = new UnicodeBlock("SYRIAC", 13);
        public static final UnicodeBlock THAANA = new UnicodeBlock("THAANA", 14);
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("DEVANAGARI", 15);
        public static final UnicodeBlock BENGALI = new UnicodeBlock("BENGALI", 16);
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("GURMUKHI", 17);
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("GUJARATI", 18);
        public static final UnicodeBlock ORIYA = new UnicodeBlock("ORIYA", 19);
        public static final UnicodeBlock TAMIL = new UnicodeBlock("TAMIL", 20);
        public static final UnicodeBlock TELUGU = new UnicodeBlock("TELUGU", 21);
        public static final UnicodeBlock KANNADA = new UnicodeBlock("KANNADA", 22);
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("MALAYALAM", 23);
        public static final UnicodeBlock SINHALA = new UnicodeBlock("SINHALA", 24);
        public static final UnicodeBlock THAI = new UnicodeBlock("THAI", 25);
        public static final UnicodeBlock LAO = new UnicodeBlock("LAO", 26);
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("TIBETAN", 27);
        public static final UnicodeBlock MYANMAR = new UnicodeBlock("MYANMAR", 28);
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("GEORGIAN", 29);
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO", 30);
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock("ETHIOPIC", 31);
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock("CHEROKEE", 32);
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", 33);
        public static final UnicodeBlock OGHAM = new UnicodeBlock("OGHAM", 34);
        public static final UnicodeBlock RUNIC = new UnicodeBlock("RUNIC", 35);
        public static final UnicodeBlock KHMER = new UnicodeBlock("KHMER", 36);
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock("MONGOLIAN", 37);
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL", 38);
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED", 39);
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION", 40);
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS", 41);
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS", 42);
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS", 43);
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS", 44);
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS", 45);
        public static final UnicodeBlock ARROWS = new UnicodeBlock("ARROWS", 46);
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS", 47);
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL", 48);
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES", 49);
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION", 50);
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS", 51);
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("BOX_DRAWING", 52);
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS", 53);
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES", 54);
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS", 55);
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("DINGBATS", 56);
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock("BRAILLE_PATTERNS", 57);
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock("CJK_RADICALS_SUPPLEMENT", 58);
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock("KANGXI_RADICALS", 59);
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock("IDEOGRAPHIC_DESCRIPTION_CHARACTERS", 60);
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION", 61);
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("HIRAGANA", 62);
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("KATAKANA", 63);
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("BOPOMOFO", 64);
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO", 65);
        public static final UnicodeBlock KANBUN = new UnicodeBlock("KANBUN", 66);
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock("BOPOMOFO_EXTENDED", 67);
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS", 68);
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY", 69);
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", 70);
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS", 71);
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock("YI_SYLLABLES", 72);
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock("YI_RADICALS", 73);
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES", 74);
        public static final UnicodeBlock HIGH_SURROGATES = new UnicodeBlock("HIGH_SURROGATES", 75);
        public static final UnicodeBlock HIGH_PRIVATE_USE_SURROGATES = new UnicodeBlock("HIGH_PRIVATE_USE_SURROGATES", 76);
        public static final UnicodeBlock LOW_SURROGATES = new UnicodeBlock("LOW_SURROGATES", 77);
        public static final UnicodeBlock PRIVATE_USE_AREA;
        public static final UnicodeBlock PRIVATE_USE;
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS;
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS;
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A;
        public static final UnicodeBlock COMBINING_HALF_MARKS;
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS;
        public static final UnicodeBlock SMALL_FORM_VARIANTS;
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B;
        public static final UnicodeBlock SPECIALS;
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS;
        public static final UnicodeBlock OLD_ITALIC;
        public static final UnicodeBlock GOTHIC;
        public static final UnicodeBlock DESERET;
        public static final UnicodeBlock BYZANTINE_MUSICAL_SYMBOLS;
        public static final UnicodeBlock MUSICAL_SYMBOLS;
        public static final UnicodeBlock MATHEMATICAL_ALPHANUMERIC_SYMBOLS;
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B;
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT;
        public static final UnicodeBlock TAGS;
        public static final UnicodeBlock CYRILLIC_SUPPLEMENTARY;
        public static final UnicodeBlock CYRILLIC_SUPPLEMENT;
        public static final UnicodeBlock TAGALOG;
        public static final UnicodeBlock HANUNOO;
        public static final UnicodeBlock BUHID;
        public static final UnicodeBlock TAGBANWA;
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A;
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_A;
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_B;
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B;
        public static final UnicodeBlock SUPPLEMENTAL_MATHEMATICAL_OPERATORS;
        public static final UnicodeBlock KATAKANA_PHONETIC_EXTENSIONS;
        public static final UnicodeBlock VARIATION_SELECTORS;
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_A;
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_B;
        public static final UnicodeBlock LIMBU;
        public static final UnicodeBlock TAI_LE;
        public static final UnicodeBlock KHMER_SYMBOLS;
        public static final UnicodeBlock PHONETIC_EXTENSIONS;
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_ARROWS;
        public static final UnicodeBlock YIJING_HEXAGRAM_SYMBOLS;
        public static final UnicodeBlock LINEAR_B_SYLLABARY;
        public static final UnicodeBlock LINEAR_B_IDEOGRAMS;
        public static final UnicodeBlock AEGEAN_NUMBERS;
        public static final UnicodeBlock UGARITIC;
        public static final UnicodeBlock SHAVIAN;
        public static final UnicodeBlock OSMANYA;
        public static final UnicodeBlock CYPRIOT_SYLLABARY;
        public static final UnicodeBlock TAI_XUAN_JING_SYMBOLS;
        public static final UnicodeBlock VARIATION_SELECTORS_SUPPLEMENT;
        public static final UnicodeBlock ANCIENT_GREEK_MUSICAL_NOTATION;
        public static final UnicodeBlock ANCIENT_GREEK_NUMBERS;
        public static final UnicodeBlock ARABIC_SUPPLEMENT;
        public static final UnicodeBlock BUGINESE;
        public static final UnicodeBlock CJK_STROKES;
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS_SUPPLEMENT;
        public static final UnicodeBlock COPTIC;
        public static final UnicodeBlock ETHIOPIC_EXTENDED;
        public static final UnicodeBlock ETHIOPIC_SUPPLEMENT;
        public static final UnicodeBlock GEORGIAN_SUPPLEMENT;
        public static final UnicodeBlock GLAGOLITIC;
        public static final UnicodeBlock KHAROSHTHI;
        public static final UnicodeBlock MODIFIER_TONE_LETTERS;
        public static final UnicodeBlock NEW_TAI_LUE;
        public static final UnicodeBlock OLD_PERSIAN;
        public static final UnicodeBlock PHONETIC_EXTENSIONS_SUPPLEMENT;
        public static final UnicodeBlock SUPPLEMENTAL_PUNCTUATION;
        public static final UnicodeBlock SYLOTI_NAGRI;
        public static final UnicodeBlock TIFINAGH;
        public static final UnicodeBlock VERTICAL_FORMS;
        public static final UnicodeBlock NKO;
        public static final UnicodeBlock BALINESE;
        public static final UnicodeBlock LATIN_EXTENDED_C;
        public static final UnicodeBlock LATIN_EXTENDED_D;
        public static final UnicodeBlock PHAGS_PA;
        public static final UnicodeBlock PHOENICIAN;
        public static final UnicodeBlock CUNEIFORM;
        public static final UnicodeBlock CUNEIFORM_NUMBERS_AND_PUNCTUATION;
        public static final UnicodeBlock COUNTING_ROD_NUMERALS;
        public static final UnicodeBlock SUNDANESE;
        public static final UnicodeBlock LEPCHA;
        public static final UnicodeBlock OL_CHIKI;
        public static final UnicodeBlock CYRILLIC_EXTENDED_A;
        public static final UnicodeBlock VAI;
        public static final UnicodeBlock CYRILLIC_EXTENDED_B;
        public static final UnicodeBlock SAURASHTRA;
        public static final UnicodeBlock KAYAH_LI;
        public static final UnicodeBlock REJANG;
        public static final UnicodeBlock CHAM;
        public static final UnicodeBlock ANCIENT_SYMBOLS;
        public static final UnicodeBlock PHAISTOS_DISC;
        public static final UnicodeBlock LYCIAN;
        public static final UnicodeBlock CARIAN;
        public static final UnicodeBlock LYDIAN;
        public static final UnicodeBlock MAHJONG_TILES;
        public static final UnicodeBlock DOMINO_TILES;
        public static final UnicodeBlock INVALID_CODE;
        private static final UnicodeBlock[] BLOCKS_;
        private int m_id_;

        static int idOf(int ch) {
            if (ch < 0 || ch > 0x10FFFF) {
                return -1;
            }
            return (PROPERTY_.getAdditional(ch, 0) & 0x1FF00) >> 8;
        }

        private UnicodeBlock(String name, int id) {
            super(name);
            this.m_id_ = id;
        }

        static {
            PRIVATE_USE = PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA", 78);
            CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS", 79);
            ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS", 80);
            ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A", 81);
            COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS", 82);
            CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS", 83);
            SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS", 84);
            ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B", 85);
            SPECIALS = new UnicodeBlock("SPECIALS", 86);
            HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS", 87);
            OLD_ITALIC = new UnicodeBlock("OLD_ITALIC", 88);
            GOTHIC = new UnicodeBlock("GOTHIC", 89);
            DESERET = new UnicodeBlock("DESERET", 90);
            BYZANTINE_MUSICAL_SYMBOLS = new UnicodeBlock("BYZANTINE_MUSICAL_SYMBOLS", 91);
            MUSICAL_SYMBOLS = new UnicodeBlock("MUSICAL_SYMBOLS", 92);
            MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeBlock("MATHEMATICAL_ALPHANUMERIC_SYMBOLS", 93);
            CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", 94);
            CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", 95);
            TAGS = new UnicodeBlock("TAGS", 96);
            CYRILLIC_SUPPLEMENTARY = new UnicodeBlock("CYRILLIC_SUPPLEMENTARY", 97);
            CYRILLIC_SUPPLEMENT = new UnicodeBlock("CYRILLIC_SUPPLEMENT", 97);
            TAGALOG = new UnicodeBlock("TAGALOG", 98);
            HANUNOO = new UnicodeBlock("HANUNOO", 99);
            BUHID = new UnicodeBlock("BUHID", 100);
            TAGBANWA = new UnicodeBlock("TAGBANWA", 101);
            MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", 102);
            SUPPLEMENTAL_ARROWS_A = new UnicodeBlock("SUPPLEMENTAL_ARROWS_A", 103);
            SUPPLEMENTAL_ARROWS_B = new UnicodeBlock("SUPPLEMENTAL_ARROWS_B", 104);
            MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", 105);
            SUPPLEMENTAL_MATHEMATICAL_OPERATORS = new UnicodeBlock("SUPPLEMENTAL_MATHEMATICAL_OPERATORS", 106);
            KATAKANA_PHONETIC_EXTENSIONS = new UnicodeBlock("KATAKANA_PHONETIC_EXTENSIONS", 107);
            VARIATION_SELECTORS = new UnicodeBlock("VARIATION_SELECTORS", 108);
            SUPPLEMENTARY_PRIVATE_USE_AREA_A = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_A", 109);
            SUPPLEMENTARY_PRIVATE_USE_AREA_B = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_B", 110);
            LIMBU = new UnicodeBlock("LIMBU", 111);
            TAI_LE = new UnicodeBlock("TAI_LE", 112);
            KHMER_SYMBOLS = new UnicodeBlock("KHMER_SYMBOLS", 113);
            PHONETIC_EXTENSIONS = new UnicodeBlock("PHONETIC_EXTENSIONS", 114);
            MISCELLANEOUS_SYMBOLS_AND_ARROWS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS_AND_ARROWS", 115);
            YIJING_HEXAGRAM_SYMBOLS = new UnicodeBlock("YIJING_HEXAGRAM_SYMBOLS", 116);
            LINEAR_B_SYLLABARY = new UnicodeBlock("LINEAR_B_SYLLABARY", 117);
            LINEAR_B_IDEOGRAMS = new UnicodeBlock("LINEAR_B_IDEOGRAMS", 118);
            AEGEAN_NUMBERS = new UnicodeBlock("AEGEAN_NUMBERS", 119);
            UGARITIC = new UnicodeBlock("UGARITIC", 120);
            SHAVIAN = new UnicodeBlock("SHAVIAN", 121);
            OSMANYA = new UnicodeBlock("OSMANYA", 122);
            CYPRIOT_SYLLABARY = new UnicodeBlock("CYPRIOT_SYLLABARY", 123);
            TAI_XUAN_JING_SYMBOLS = new UnicodeBlock("TAI_XUAN_JING_SYMBOLS", 124);
            VARIATION_SELECTORS_SUPPLEMENT = new UnicodeBlock("VARIATION_SELECTORS_SUPPLEMENT", 125);
            ANCIENT_GREEK_MUSICAL_NOTATION = new UnicodeBlock("ANCIENT_GREEK_MUSICAL_NOTATION", 126);
            ANCIENT_GREEK_NUMBERS = new UnicodeBlock("ANCIENT_GREEK_NUMBERS", 127);
            ARABIC_SUPPLEMENT = new UnicodeBlock("ARABIC_SUPPLEMENT", 128);
            BUGINESE = new UnicodeBlock("BUGINESE", 129);
            CJK_STROKES = new UnicodeBlock("CJK_STROKES", 130);
            COMBINING_DIACRITICAL_MARKS_SUPPLEMENT = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS_SUPPLEMENT", 131);
            COPTIC = new UnicodeBlock("COPTIC", 132);
            ETHIOPIC_EXTENDED = new UnicodeBlock("ETHIOPIC_EXTENDED", 133);
            ETHIOPIC_SUPPLEMENT = new UnicodeBlock("ETHIOPIC_SUPPLEMENT", 134);
            GEORGIAN_SUPPLEMENT = new UnicodeBlock("GEORGIAN_SUPPLEMENT", 135);
            GLAGOLITIC = new UnicodeBlock("GLAGOLITIC", 136);
            KHAROSHTHI = new UnicodeBlock("KHAROSHTHI", 137);
            MODIFIER_TONE_LETTERS = new UnicodeBlock("MODIFIER_TONE_LETTERS", 138);
            NEW_TAI_LUE = new UnicodeBlock("NEW_TAI_LUE", 139);
            OLD_PERSIAN = new UnicodeBlock("OLD_PERSIAN", 140);
            PHONETIC_EXTENSIONS_SUPPLEMENT = new UnicodeBlock("PHONETIC_EXTENSIONS_SUPPLEMENT", 141);
            SUPPLEMENTAL_PUNCTUATION = new UnicodeBlock("SUPPLEMENTAL_PUNCTUATION", 142);
            SYLOTI_NAGRI = new UnicodeBlock("SYLOTI_NAGRI", 143);
            TIFINAGH = new UnicodeBlock("TIFINAGH", 144);
            VERTICAL_FORMS = new UnicodeBlock("VERTICAL_FORMS", 145);
            NKO = new UnicodeBlock("NKO", 146);
            BALINESE = new UnicodeBlock("BALINESE", 147);
            LATIN_EXTENDED_C = new UnicodeBlock("LATIN_EXTENDED_C", 148);
            LATIN_EXTENDED_D = new UnicodeBlock("LATIN_EXTENDED_D", 149);
            PHAGS_PA = new UnicodeBlock("PHAGS_PA", 150);
            PHOENICIAN = new UnicodeBlock("PHOENICIAN", 151);
            CUNEIFORM = new UnicodeBlock("CUNEIFORM", 152);
            CUNEIFORM_NUMBERS_AND_PUNCTUATION = new UnicodeBlock("CUNEIFORM_NUMBERS_AND_PUNCTUATION", 153);
            COUNTING_ROD_NUMERALS = new UnicodeBlock("COUNTING_ROD_NUMERALS", 154);
            SUNDANESE = new UnicodeBlock("SUNDANESE", 155);
            LEPCHA = new UnicodeBlock("LEPCHA", 156);
            OL_CHIKI = new UnicodeBlock("OL_CHIKI", 157);
            CYRILLIC_EXTENDED_A = new UnicodeBlock("CYRILLIC_EXTENDED_A", 158);
            VAI = new UnicodeBlock("VAI", 159);
            CYRILLIC_EXTENDED_B = new UnicodeBlock("CYRILLIC_EXTENDED_B", 160);
            SAURASHTRA = new UnicodeBlock("SAURASHTRA", 161);
            KAYAH_LI = new UnicodeBlock("KAYAH_LI", 162);
            REJANG = new UnicodeBlock("REJANG", 163);
            CHAM = new UnicodeBlock("CHAM", 164);
            ANCIENT_SYMBOLS = new UnicodeBlock("ANCIENT_SYMBOLS", 165);
            PHAISTOS_DISC = new UnicodeBlock("PHAISTOS_DISC", 166);
            LYCIAN = new UnicodeBlock("LYCIAN", 167);
            CARIAN = new UnicodeBlock("CARIAN", 168);
            LYDIAN = new UnicodeBlock("LYDIAN", 169);
            MAHJONG_TILES = new UnicodeBlock("MAHJONG_TILES", 170);
            DOMINO_TILES = new UnicodeBlock("DOMINO_TILES", 171);
            INVALID_CODE = new UnicodeBlock("INVALID_CODE", -1);
            BLOCKS_ = new UnicodeBlock[]{NO_BLOCK, BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, ARMENIAN, HEBREW, ARABIC, SYRIAC, THAANA, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, KHMER, MONGOLIAN, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, BRAILLE_PATTERNS, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, HANGUL_SYLLABLES, HIGH_SURROGATES, HIGH_PRIVATE_USE_SURROGATES, LOW_SURROGATES, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, SPECIALS, HALFWIDTH_AND_FULLWIDTH_FORMS, OLD_ITALIC, GOTHIC, DESERET, BYZANTINE_MUSICAL_SYMBOLS, MUSICAL_SYMBOLS, MATHEMATICAL_ALPHANUMERIC_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, TAGS, CYRILLIC_SUPPLEMENT, TAGALOG, HANUNOO, BUHID, TAGBANWA, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, SUPPLEMENTAL_ARROWS_A, SUPPLEMENTAL_ARROWS_B, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, SUPPLEMENTAL_MATHEMATICAL_OPERATORS, KATAKANA_PHONETIC_EXTENSIONS, VARIATION_SELECTORS, SUPPLEMENTARY_PRIVATE_USE_AREA_A, SUPPLEMENTARY_PRIVATE_USE_AREA_B, LIMBU, TAI_LE, KHMER_SYMBOLS, PHONETIC_EXTENSIONS, MISCELLANEOUS_SYMBOLS_AND_ARROWS, YIJING_HEXAGRAM_SYMBOLS, LINEAR_B_SYLLABARY, LINEAR_B_IDEOGRAMS, AEGEAN_NUMBERS, UGARITIC, SHAVIAN, OSMANYA, CYPRIOT_SYLLABARY, TAI_XUAN_JING_SYMBOLS, VARIATION_SELECTORS_SUPPLEMENT, ANCIENT_GREEK_MUSICAL_NOTATION, ANCIENT_GREEK_NUMBERS, ARABIC_SUPPLEMENT, BUGINESE, CJK_STROKES, COMBINING_DIACRITICAL_MARKS_SUPPLEMENT, COPTIC, ETHIOPIC_EXTENDED, ETHIOPIC_SUPPLEMENT, GEORGIAN_SUPPLEMENT, GLAGOLITIC, KHAROSHTHI, MODIFIER_TONE_LETTERS, NEW_TAI_LUE, OLD_PERSIAN, PHONETIC_EXTENSIONS_SUPPLEMENT, SUPPLEMENTAL_PUNCTUATION, SYLOTI_NAGRI, TIFINAGH, VERTICAL_FORMS, NKO, BALINESE, LATIN_EXTENDED_C, LATIN_EXTENDED_D, PHAGS_PA, PHOENICIAN, CUNEIFORM, CUNEIFORM_NUMBERS_AND_PUNCTUATION, COUNTING_ROD_NUMERALS, SUNDANESE, LEPCHA, OL_CHIKI, CYRILLIC_EXTENDED_A, VAI, CYRILLIC_EXTENDED_B, SAURASHTRA, KAYAH_LI, REJANG, CHAM, ANCIENT_SYMBOLS, PHAISTOS_DISC, LYCIAN, CARIAN, LYDIAN, MAHJONG_TILES, DOMINO_TILES};
            if (172 != BLOCKS_.length) {
                throw new IllegalStateException("UnicodeBlock fields are inconsistent!");
            }
        }
    }
}

