/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.rendercondition;

import com.adobe.granite.ui.components.impl.SlingIncludeObjectFactory;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

public class RenderConditionHelper {
    @Nonnull
    private static final String NAME_RENDERCONDITION = "granite:rendercondition";
    private static final String ATTRIBUTE_CACHE_RC = RenderConditionHelper.class.getName();
    @Nonnull
    private SlingHttpServletRequest request;
    @Nonnull
    private SlingHttpServletResponse response;

    public RenderConditionHelper(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Nonnull
    public RenderCondition getRenderCondition(@Nonnull Resource resource) throws ServletException, IOException {
        return this.getRenderCondition(resource, false);
    }

    @Nonnull
    public RenderCondition getRenderCondition(@Nonnull Resource resource, boolean cache) throws ServletException, IOException {
        String key;
        Map<String, RenderCondition> cacheMap = this.getRenderConditionCache();
        RenderCondition rc = cacheMap.get(key = resource.getPath());
        if (rc != null) {
            return rc;
        }
        Resource condition = resource.getChild(NAME_RENDERCONDITION);
        if (condition != null) {
            SlingIncludeObjectFactory factory = new SlingIncludeObjectFactory(this.request, this.response);
            rc = (RenderCondition)factory.get(condition, RenderConditionHelper.getResourceType(condition), RenderCondition.class);
        }
        if (rc == null) {
            rc = SimpleRenderCondition.TRUE;
        }
        if (cache) {
            cacheMap.put(key, rc);
        }
        return rc;
    }

    @Nonnull
    private Map<String, RenderCondition> getRenderConditionCache() {
        HashMap cache = (HashMap)this.request.getAttribute(ATTRIBUTE_CACHE_RC);
        if (cache == null) {
            cache = new HashMap();
            this.request.setAttribute(ATTRIBUTE_CACHE_RC, cache);
        }
        return cache;
    }

    @CheckForNull
    private static String getResourceType(@Nonnull Resource resource) {
        return (String)((Object)resource.getValueMap().get("sling:resourceType", String.class));
    }
}

