/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.schema.rng.model;

import com.adobe.xmp.schema.model.ArrayType;
import com.adobe.xmp.schema.rng.model.DatatypeInfo;
import com.adobe.xmp.schema.rng.model.ParamInfoGroup;
import com.adobe.xmp.schema.rng.model.PropertyAnnotationInfo;
import com.adobe.xmp.schema.rng.model.SchemaInfo;
import com.adobe.xmp.schema.rng.parser.annotation.RNGDecorationAnnotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfo
implements PropertyAnnotationInfo {
    private String mNS;
    private String mName;
    private ParamInfoGroup mParamInfos;
    private DatatypeInfo mRawDataType;
    private DatatypeInfo mDataType;
    private Stack<PropertyInfo> mFields;
    private Stack<PropertyInfo> mQualifiers;
    private ArrayType.ArrayForm mArrayForm;
    private String mLabel;
    private String mDescription;
    private RNGDecorationAnnotation.ACCESS mAccess;
    private RNGDecorationAnnotation.CHOICE choice;
    private boolean mDeprecated;
    private boolean mMandatory;
    private boolean mIsQualifier;
    private boolean mIsArrayItemQualifier;
    private SchemaInfo mSchemaInfo;
    private HashMap<QName, Map<String, String>> mDecoratorStore;

    public PropertyInfo(String ns, String name, SchemaInfo schemaInfo) {
        this.mNS = ns;
        this.mName = name;
        this.mParamInfos = new ParamInfoGroup(ParamInfoGroup.Operator.kAND);
        this.mRawDataType = new DatatypeInfo("Text", true);
        this.mFields = new Stack();
        this.mQualifiers = new Stack();
        this.mArrayForm = null;
        this.mLabel = "";
        this.mDescription = "";
        this.mAccess = null;
        this.mDeprecated = false;
        this.mMandatory = true;
        this.mIsQualifier = false;
        this.mIsArrayItemQualifier = false;
        this.mSchemaInfo = schemaInfo;
    }

    public void addChild(PropertyInfo child) {
        if (child.isQualifier() || child.isArrayItemQualifier()) {
            this.mQualifiers.add(child);
        } else {
            this.mFields.add(child);
        }
    }

    public Stack<PropertyInfo> getQualifiers() {
        return this.mQualifiers;
    }

    public Stack<PropertyInfo> getFields() {
        return this.mFields;
    }

    public void setNS(String mNS) {
        this.mNS = mNS;
    }

    public String getNS() {
        return this.mNS;
    }

    public void setName(String mName) {
        this.mName = mName;
    }

    public String getName() {
        return this.mName;
    }

    public void setParamInfos(ParamInfoGroup mParamInfos) {
        if (this.mParamInfos == null || this.mParamInfos.size() == 0) {
            this.mParamInfos = mParamInfos;
        } else {
            this.mParamInfos.push(mParamInfos);
        }
    }

    public ParamInfoGroup getParamInfos() {
        return this.mParamInfos;
    }

    public void setRawDataType(DatatypeInfo mRawDataType) {
        this.mRawDataType = mRawDataType;
    }

    public DatatypeInfo getRawDataType() {
        return this.mRawDataType;
    }

    public void setDataType(DatatypeInfo mDataType) {
        this.mDataType = mDataType;
    }

    public DatatypeInfo getDataType() {
        return this.mDataType;
    }

    public void setArrayForm(ArrayType.ArrayForm form) {
        this.mArrayForm = form;
    }

    public ArrayType.ArrayForm getArrayForm() {
        return this.mArrayForm;
    }

    @Override
    public void setLabel(String mLabel) {
        this.mLabel = mLabel;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void setDescription(String mDescription) {
        this.mDescription = mDescription;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setAccess(RNGDecorationAnnotation.ACCESS mAccess) {
        this.mAccess = mAccess;
    }

    @Override
    public RNGDecorationAnnotation.ACCESS getAccess() {
        return this.mAccess;
    }

    public void setDeprecated(boolean mDeprecated) {
        this.mDeprecated = mDeprecated;
    }

    public boolean isDeprecated() {
        return this.mDeprecated;
    }

    public void setMandatory(boolean mMandatory) {
        this.mMandatory = mMandatory;
    }

    public boolean isMandatory() {
        return this.mMandatory;
    }

    public void setIsArrayItemQualifier(boolean isArrayItemQualifier) {
        this.mIsArrayItemQualifier = isArrayItemQualifier;
    }

    public boolean isArrayItemQualifier() {
        return this.mIsArrayItemQualifier;
    }

    public void setIsQualifier(boolean isQualifier) {
        this.mIsQualifier = isQualifier;
    }

    public boolean isQualifier() {
        return this.mIsQualifier;
    }

    public void setSchemaInfo(SchemaInfo mSchemaInfo) {
        this.mSchemaInfo = mSchemaInfo;
    }

    public SchemaInfo getSchemaInfo() {
        return this.mSchemaInfo;
    }

    public void setChoice(RNGDecorationAnnotation.CHOICE choice) {
        this.choice = choice;
    }

    public RNGDecorationAnnotation.CHOICE getChoice() {
        return this.choice;
    }

    public boolean hasDecorators() {
        return this.mDecoratorStore != null && this.mDecoratorStore.size() > 0;
    }

    public HashMap<QName, Map<String, String>> getDecoratorStore() {
        if (this.mDecoratorStore == null) {
            this.mDecoratorStore = new HashMap();
        }
        return this.mDecoratorStore;
    }

    public Map<String, String> getDecorator(QName qname) {
        Map<String, String> map = this.getDecoratorStore().get(qname);
        if (map == null) {
            map = new HashMap<String, String>();
            this.mDecoratorStore.put(qname, map);
        }
        return map;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nName = ").append(this.mName);
        str.append(" - Ns = ").append(this.mNS);
        str.append(" - label = ").append(this.mLabel);
        str.append("\nDeprecated = ").append(this.mDeprecated);
        str.append("\nMandatory = ").append(this.mMandatory);
        if (this.mFields != null && this.mFields.size() > 0) {
            str.append("\n========= Fields  ===============");
            for (PropertyInfo p : this.mFields) {
                str.append(p.toString());
            }
            str.append("\n=================================");
        }
        if (this.mQualifiers != null && this.mQualifiers.size() > 0) {
            str.append("\n========= Qualifiers  ===============");
            for (PropertyInfo p : this.mQualifiers) {
                str.append(p.toString());
            }
            str.append("\n=================================");
        }
        if (this.mArrayForm != null) {
            str.append("\n Array Type " + (Object)((Object)this.mArrayForm));
        }
        if (this.mParamInfos != null) {
            str.append("\n========= Param Info  ===============");
            str.append("\n" + this.mParamInfos);
            str.append("\n=================================");
        }
        if (this.mDataType != null) {
            str.append("\n DataType" + this.mDataType);
        }
        if (this.mRawDataType != null) {
            str.append("\n Raw DataType" + this.mRawDataType);
        }
        return str.toString();
    }
}

