/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.util;

import com.day.cq.analytics.sitecatalyst.util.TokenProviderProxy;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsConfig {
    private String companyId;
    private String apiKey;
    private String token = null;
    private static final Logger log = LoggerFactory.getLogger(AnalyticsConfig.class);

    public AnalyticsConfig(Map config, TokenProviderProxy tokenProviderProxy) {
        this.companyId = PropertiesUtil.toString(config.get("x-proxy-global-company-id"), "");
        String imsConfigId = PropertiesUtil.toString(config.get("imsConfigId"), "");
        this.apiKey = tokenProviderProxy.getApikey(imsConfigId);
        try {
            this.token = tokenProviderProxy.getAccessToken(imsConfigId);
        }
        catch (Exception e) {
            log.error("Cannot get the access token for {}", (Object)imsConfigId);
        }
    }

    @Nonnull
    public String getCompanyId() {
        return this.companyId;
    }

    @Nonnull
    public String getApikey() {
        return this.apiKey;
    }

    @Nullable
    public String getAccessToken() {
        return this.token;
    }
}

