/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import java.io.IOException;
import java.io.Writer;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;

public class TidyJSONWriter
extends JSONWriter {
    private static final int maxdepth = 50;
    private static final String[] INDENTS = new String[50];
    private boolean tidy;
    private boolean comma = false;
    protected char mode = (char)105;
    private char[] stack = new char[50];
    private int top = 0;
    protected Writer writer;

    public TidyJSONWriter(Writer w) {
        super(w);
        this.writer = w;
    }

    @Override
    public boolean isTidy() {
        return this.tidy;
    }

    @Override
    public void setTidy(boolean tidy) {
        this.tidy = tidy;
    }

    private TidyJSONWriter append(String s) throws JSONException {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                if (this.tidy && this.mode == 'a' && !"{".equals(s) && !"[".equals(s)) {
                    this.writer.write(10);
                    this.writer.write(INDENTS[this.top]);
                }
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    @Override
    public TidyJSONWriter array() throws JSONException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private TidyJSONWriter end(char m, char c) throws JSONException {
        if (this.mode != m) {
            throw new JSONException(m == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        try {
            if (this.tidy) {
                this.writer.write(10);
                this.writer.write(INDENTS[this.top]);
            }
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.comma = true;
        return this;
    }

    @Override
    public TidyJSONWriter endArray() throws JSONException {
        return this.end('a', ']');
    }

    @Override
    public TidyJSONWriter endObject() throws JSONException {
        return this.end('k', '}');
    }

    @Override
    public TidyJSONWriter key(String s) throws JSONException {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                if (this.comma) {
                    this.writer.write(44);
                }
                if (this.tidy) {
                    this.writer.write(10);
                    this.writer.write(INDENTS[this.top]);
                }
                this.writer.write(JSONObject.quote(s));
                this.writer.write(58);
                if (this.tidy) {
                    this.writer.write(32);
                }
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    @Override
    public TidyJSONWriter object() throws JSONException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c) throws JSONException {
        if (this.top <= 0 || this.stack[this.top - 1] != c) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c) throws JSONException {
        if (this.top >= 50) {
            throw new JSONException("Nesting too deep (maximum is 50 levels)");
        }
        this.stack[this.top] = c;
        this.mode = c;
        ++this.top;
    }

    @Override
    public TidyJSONWriter value(boolean b) throws JSONException {
        return this.append(b ? "true" : "false");
    }

    @Override
    public TidyJSONWriter value(double d) throws JSONException {
        return this.value(new Double(d));
    }

    @Override
    public TidyJSONWriter value(long l) throws JSONException {
        return this.append(Long.toString(l));
    }

    @Override
    public TidyJSONWriter value(Object o) throws JSONException {
        return this.append(JSONObject.valueToString(o));
    }

    static {
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < INDENTS.length; ++i) {
            TidyJSONWriter.INDENTS[i] = indent.toString();
            indent.append("  ");
        }
    }
}

