/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.VariableResolver;

@Deprecated(since="2021-04-30")
public final class WebConsoleUtil {
    private WebConsoleUtil() {
    }

    public static VariableResolver getVariableResolver(ServletRequest request) {
        Object resolverObj = request.getAttribute("felix.webconsole.variable.resolver");
        if (resolverObj instanceof VariableResolver) {
            return (VariableResolver)resolverObj;
        }
        DefaultVariableResolver resolver = new DefaultVariableResolver();
        resolver.put("appRoot", request.getAttribute("felix.webconsole.appRoot"));
        resolver.put("pluginRoot", request.getAttribute("felix.webconsole.pluginRoot"));
        WebConsoleUtil.setVariableResolver(request, resolver);
        return resolver;
    }

    public static void setVariableResolver(ServletRequest request, VariableResolver resolver) {
        request.setAttribute("felix.webconsole.variable.resolver", resolver);
    }

    public static final String getParameter(HttpServletRequest request, String name) {
        FileItem[] param;
        if (!FileUploadBase.isMultipartContent(new ServletRequestContext(request))) {
            return request.getParameter(name);
        }
        HashMap<String, FileItem[]> params = (HashMap<String, FileItem[]>)request.getAttribute("org.apache.felix.webconsole.fileupload");
        if (params == null) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(256000);
            Object repo = request.getAttribute("org.apache.felix.webconsole.fileupload.repo");
            if (repo instanceof File) {
                factory.setRepository((File)repo);
            }
            ServletFileUpload upload = new ServletFileUpload(factory);
            upload.setSizeMax(-1L);
            upload.setFileCountMax(50L);
            params = new HashMap<String, FileItem[]>();
            try {
                List<FileItem> items = upload.parseRequest(request);
                for (FileItem fi : items) {
                    FileItem[] current = (FileItem[])params.get(fi.getFieldName());
                    if (current == null) {
                        current = new FileItem[]{fi};
                    } else {
                        FileItem[] newCurrent = new FileItem[current.length + 1];
                        System.arraycopy(current, 0, newCurrent, 0, current.length);
                        newCurrent[current.length] = fi;
                        current = newCurrent;
                    }
                    params.put(fi.getFieldName(), current);
                }
            }
            catch (FileUploadException fileUploadException) {
                // empty catch block
            }
            request.setAttribute("org.apache.felix.webconsole.fileupload", params);
        }
        if ((param = (FileItem[])params.get(name)) != null) {
            for (int i = 0; i < param.length; ++i) {
                if (!param[i].isFormField()) continue;
                return param[i].getString();
            }
        }
        return null;
    }

    public static final void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        if (!redirectUrl.startsWith("/")) {
            String base = request.getContextPath() + request.getServletPath() + request.getPathInfo();
            int i = base.lastIndexOf(47);
            if (i > -1) {
                base = base.substring(0, i);
            } else {
                i = base.indexOf(58);
                String string = base = i > -1 ? base.substring(i + 1, base.length()) : "";
            }
            if (!base.startsWith("/")) {
                base = '/' + base;
            }
            redirectUrl = base + '/' + redirectUrl;
        }
        response.sendRedirect(redirectUrl);
    }

    public static final void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Cache-Control", "max-age=0");
        response.setHeader("Expires", "Thu, 01 Jan 1970 01:00:00 GMT");
        response.setHeader("Pragma", "no-cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String escapeHtml(String text) {
        StringBuffer sb;
        StringBuffer stringBuffer = sb = new StringBuffer(text.length() * 4 / 3);
        synchronized (stringBuffer) {
            int oldch = 95;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '<': {
                        sb.append("&lt;");
                        break;
                    }
                    case '>': {
                        sb.append("&gt;");
                        break;
                    }
                    case '&': {
                        sb.append("&amp;");
                        break;
                    }
                    case ' ': {
                        sb.append("&nbsp;");
                        break;
                    }
                    case '\'': {
                        sb.append("&apos;");
                        break;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (oldch == 13 || oldch == 10) break;
                        sb.append("<br/>\n");
                        break;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
                oldch = ch;
            }
            return sb.toString();
        }
    }

    public static final int getParameterInt(HttpServletRequest request, String name, int _default) {
        int ret = _default;
        String param = request.getParameter(name);
        try {
            if (param != null) {
                ret = Integer.parseInt(param);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    public static String urlDecode(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (Throwable t) {
            return URLDecoder.decode(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toString(Object value) {
        if (value == null) {
            return "n/a";
        }
        if (value.getClass().isArray()) {
            StringBuffer sb = new StringBuffer();
            int len = Array.getLength(value);
            StringBuffer stringBuffer = sb;
            synchronized (stringBuffer) {
                sb.append('[');
                for (int i = 0; i < len; ++i) {
                    Object element = Array.get(value, i);
                    if (element instanceof Byte) {
                        sb.append("0x");
                        String x = Integer.toHexString(((Byte)element).intValue() & 0xFF);
                        if (1 == x.length()) {
                            sb.append('0');
                        }
                        sb.append(x);
                    } else {
                        sb.append(WebConsoleUtil.toString(element));
                    }
                    if (i >= len - 1) continue;
                    sb.append(", ");
                }
                return sb.append(']').toString();
            }
        }
        return value.toString();
    }
}

