/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class CompositeIndexEditorProvider
implements IndexEditorProvider {
    private final List<IndexEditorProvider> providers;

    @NotNull
    public static IndexEditorProvider compose(@NotNull Collection<IndexEditorProvider> providers) {
        if (providers.isEmpty()) {
            return new IndexEditorProvider(){

                @Override
                public Editor getIndexEditor(@NotNull String type, @NotNull NodeBuilder builder, @NotNull NodeState root, @NotNull IndexUpdateCallback callback) {
                    return null;
                }
            };
        }
        if (providers.size() == 1) {
            return providers.iterator().next();
        }
        return new CompositeIndexEditorProvider((List<IndexEditorProvider>)ImmutableList.copyOf(providers));
    }

    private CompositeIndexEditorProvider(List<IndexEditorProvider> providers) {
        this.providers = providers;
    }

    public CompositeIndexEditorProvider(IndexEditorProvider ... providers) {
        this(Arrays.asList(providers));
    }

    @Override
    public Editor getIndexEditor(@NotNull String type, @NotNull NodeBuilder builder, @NotNull NodeState root, @NotNull IndexUpdateCallback callback) throws CommitFailedException {
        ArrayList indexes = Lists.newArrayList();
        for (IndexEditorProvider provider : this.providers) {
            Editor e = provider.getIndexEditor(type, builder, root, callback);
            if (e == null) continue;
            indexes.add(e);
        }
        return CompositeEditor.compose(indexes);
    }
}

