/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.fulltext;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractedText {
    public static final ExtractedText ERROR = new ExtractedText(ExtractionResult.ERROR);
    public static final ExtractedText EMPTY = new ExtractedText(ExtractionResult.EMPTY, "");
    private final ExtractionResult extractionResult;
    private final CharSequence extractedText;

    public ExtractedText(@NotNull ExtractionResult extractionResult) {
        this(extractionResult, null);
    }

    public ExtractedText(@NotNull ExtractionResult extractionResult, CharSequence extractedText) {
        this.extractionResult = extractionResult;
        this.extractedText = extractedText;
        this.checkState();
    }

    @NotNull
    public ExtractionResult getExtractionResult() {
        return this.extractionResult;
    }

    @Nullable
    public CharSequence getExtractedText() {
        return this.extractedText;
    }

    private void checkState() {
        if (this.extractionResult == ExtractionResult.SUCCESS) {
            Preconditions.checkNotNull((Object)this.extractedText, (Object)"extractedText must not be null for SUCCESS");
        }
    }

    public static enum ExtractionResult {
        SUCCESS,
        EMPTY,
        ERROR;

    }
}

