/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.io.IOException;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.plugins.index.IndexInfo;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.ApproximateCounter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PropertyIndexInfoProvider
implements IndexInfoProvider {
    @Reference
    private NodeStore nodeStore;

    public PropertyIndexInfoProvider() {
    }

    public PropertyIndexInfoProvider(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    @Override
    public String getType() {
        return "property";
    }

    @Override
    public IndexInfo getInfo(String indexPath) throws IOException {
        NodeState idxState = NodeStateUtils.getNode(this.nodeStore.getRoot(), indexPath);
        Preconditions.checkArgument((boolean)"property".equals(idxState.getString("type")), (String)"Index definition at [%s] is not of type 'property'", (Object)indexPath);
        PropertyIndexInfo info = new PropertyIndexInfo(indexPath);
        this.computeCountEstimate(info, idxState);
        return info;
    }

    private void computeCountEstimate(PropertyIndexInfo info, NodeState idxState) {
        long count = -1L;
        for (ChildNodeEntry childNodeEntry : idxState.getChildNodeEntries()) {
            if (!NodeStateUtils.isHidden(childNodeEntry.getName())) continue;
            NodeState indexData = childNodeEntry.getNodeState();
            long estimate = ApproximateCounter.getCountSync((NodeState)indexData);
            if (estimate > 0L) {
                if (count < 0L) {
                    count = 0L;
                }
                count += estimate;
                continue;
            }
            if (count >= 0L || indexData.getChildNodeCount(1L) != 0L) continue;
            count = 0L;
        }
        info.estimatedCount = count;
    }

    @Override
    public boolean isValid(String indexPath) throws IOException {
        return true;
    }

    private static class PropertyIndexInfo
    implements IndexInfo {
        private final String indexPath;
        long estimatedCount = -1L;

        public PropertyIndexInfo(String indexPath) {
            this.indexPath = indexPath;
        }

        @Override
        public String getIndexPath() {
            return this.indexPath;
        }

        @Override
        public String getType() {
            return "property";
        }

        @Override
        public String getAsyncLaneName() {
            return null;
        }

        @Override
        public long getLastUpdatedTime() {
            return -2L;
        }

        @Override
        public long getIndexedUpToTime() {
            return 0L;
        }

        @Override
        public long getEstimatedEntryCount() {
            return this.estimatedCount;
        }

        @Override
        public long getSizeInBytes() {
            return -1L;
        }

        @Override
        public boolean hasIndexDefinitionChangedWithoutReindexing() {
            return false;
        }

        @Override
        public String getIndexDefinitionDiff() {
            return null;
        }

        @Override
        public boolean hasHiddenOakLibsMount() {
            return false;
        }

        @Override
        public boolean hasPropertyIndexNode() {
            return false;
        }

        @Override
        public long getSuggestSizeInBytes() {
            return -1L;
        }

        @Override
        public long getCreationTimestamp() {
            return -1L;
        }

        @Override
        public long getReindexCompletionTimestamp() {
            return -1L;
        }
    }
}

