/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.json.io;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONString;

@Deprecated
public class JSONRenderer {
    public Options options() {
        return new Options();
    }

    private void indent(StringBuilder sb, int howMuch) {
        for (int i = 0; i < howMuch; ++i) {
            sb.append(' ');
        }
    }

    public String toString(JSONObject jo) {
        try {
            Iterator<String> keys = jo.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                String o = keys.next();
                sb.append(this.quote(o));
                sb.append(':');
                sb.append(this.valueToString(jo.opt(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(JSONArray ja) {
        try {
            return '[' + this.join(ja, ",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 2);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public void quote(Writer w, String string) throws IOException {
        w.write(this.quote(string));
    }

    public String valueToString(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return this.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        return this.quote(value.toString());
    }

    public String valueToString(Object value, Options opt) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return this.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return this.prettyPrint((JSONObject)value, opt);
        }
        if (value instanceof JSONArray) {
            return this.prettyPrint((JSONArray)value, opt);
        }
        return this.quote(value.toString());
    }

    public String numberToString(Number n) throws JSONException {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        this.testNumberValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    private boolean skipChildObject(JSONArray a, Options opt, String key, Object value) {
        if (opt.arraysForChildren && value instanceof JSONObject) {
            a.put(new NamedJSONObject(key, (JSONObject)value, opt));
            return true;
        }
        return false;
    }

    public String prettyPrint(JSONObject jo, Options opt) throws JSONException {
        Object v;
        int n = jo.length();
        if (n == 0) {
            return "{}";
        }
        JSONArray children = new JSONArray();
        Iterator<String> keys = jo.keys();
        StringBuilder sb = new StringBuilder("{");
        int newindent = opt.initialIndent + opt.indent;
        if (n == 1) {
            String o = keys.next();
            if (!this.skipChildObject(children, opt, o, v = jo.get(o))) {
                sb.append(this.quote(o));
                sb.append(": ");
                sb.append(this.valueToString(v, opt));
            }
        } else {
            while (keys.hasNext()) {
                String o = keys.next();
                if (this.skipChildObject(children, opt, o, v = jo.get(o))) continue;
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                this.indent(sb, newindent);
                sb.append(this.quote(o.toString()));
                sb.append(": ");
                sb.append(this.valueToString(v, this.options().withIndent(opt.indent).withInitialIndent(newindent)));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                this.indent(sb, newindent);
            }
        }
        if (children.length() > 0) {
            if (sb.length() > 1) {
                sb.append(",\n");
            } else {
                sb.append('\n');
            }
            Options childOpt = new Options(opt);
            childOpt.withInitialIndent(childOpt.initialIndent + newindent);
            this.indent(sb, childOpt.initialIndent);
            sb.append(this.quote(opt.childrenKey)).append(":");
            sb.append(this.prettyPrint(children, childOpt));
        }
        sb.append('}');
        return sb.toString();
    }

    public String prettyPrint(JSONArray ja, Options opt) throws JSONException {
        int len = ja.length();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(this.valueToString(ja.get(0), opt));
        } else {
            int newindent = opt.initialIndent + opt.indent;
            if (opt.hasIndent()) {
                sb.append('\n');
            }
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                    if (opt.hasIndent()) {
                        sb.append('\n');
                    }
                }
                this.indent(sb, newindent);
                sb.append(this.valueToString(ja.get(i), opt));
            }
            if (opt.hasIndent()) {
                sb.append('\n');
            }
            this.indent(sb, opt.initialIndent);
        }
        sb.append(']');
        return sb.toString();
    }

    public void testNumberValidity(Object o) throws JSONException {
        if (o != null) {
            if (o instanceof Double) {
                if (((Double)o).isInfinite() || ((Double)o).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public String join(JSONArray ja, String separator) throws JSONException {
        int len = ja.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JSONObject.valueToString(ja.get(i)));
        }
        return sb.toString();
    }

    public Writer write(Writer writer, JSONObject jo) throws JSONException {
        try {
            boolean b = false;
            Iterator<String> keys = jo.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                String k = keys.next();
                writer.write(this.quote(k));
                writer.write(58);
                Object v = jo.get(k);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(this.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public Writer write(Writer writer, JSONArray ja) throws JSONException {
        try {
            boolean b = false;
            int len = ja.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = ja.get(i)) instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    @Deprecated(since="2022-12-31")
    private static class NamedJSONObject
    extends JSONObject {
        final String name;
        final JSONObject jsonObject;
        final String nameKey;
        final List<String> keysWithName;

        NamedJSONObject(String name, JSONObject jsonObject, Options opt) {
            this.name = name;
            this.jsonObject = jsonObject;
            this.nameKey = opt.childNameKey;
            this.keysWithName = new ArrayList<String>();
            this.keysWithName.add(this.nameKey);
            Iterator<String> it = jsonObject.keys();
            while (it.hasNext()) {
                this.keysWithName.add(it.next());
            }
        }

        @Override
        public int length() {
            return this.keysWithName.size();
        }

        @Override
        public Object get(String key) throws JSONException {
            if (key.equals(this.nameKey)) {
                return this.name;
            }
            return this.jsonObject.get(key);
        }

        @Override
        public Iterator<String> keys() {
            return this.keysWithName.iterator();
        }
    }

    @Deprecated(since="2022-12-31")
    public static class Options {
        int indent;
        private boolean indentIsPositive;
        int initialIndent;
        boolean arraysForChildren;
        public static final String DEFAULT_CHILDREN_KEY = "__children__";
        public static final String DEFAULT_CHILD_NAME_KEY = "__name__";
        String childrenKey = "__children__";
        String childNameKey = "__name__";

        private Options() {
        }

        Options(Options opt) {
            this.indent = opt.indent;
            this.indentIsPositive = opt.indentIsPositive;
            this.initialIndent = opt.initialIndent;
            this.arraysForChildren = opt.arraysForChildren;
        }

        public Options withIndent(int n) {
            this.indent = n;
            this.indentIsPositive = this.indent > 0;
            return this;
        }

        public Options withInitialIndent(int n) {
            this.initialIndent = n;
            return this;
        }

        public Options withArraysForChildren(boolean b) {
            this.arraysForChildren = b;
            return this;
        }

        public Options withChildNameKey(String key) {
            this.childNameKey = key;
            return this;
        }

        public Options withChildrenKey(String key) {
            this.childrenKey = key;
            return this;
        }

        boolean hasIndent() {
            return this.indentIsPositive;
        }
    }
}

