package com.adobe.cq.mcm.campaign.profile;

import java.util.Iterator;

/**
 * Represents a single metadata definition in a hierarchical tree of meta data as retrieved
 * by {@link MetaDataRetriever}
 */
public interface MetaDataNode {

    String getId();

    String getPath();

    String getLabel();

    String getType();

    MetaDataNode add(MetaDataNode child);

    Iterator<MetaDataNode> getChildren();

    MetaDataNode getChildByPath(String relPath);

    boolean hasOptions();

    Options getOptions();

}
