package com.adobe.cq.targetrecommendations.api.model;

/**
 * Interval to be taken into account by a Recommendation Algorithm.
 */
public enum DayCountInterval {
    ONE_DAY("oneDay"), TWO_DAYS("twoDays"),
    ONE_WEEK("oneWeek"), TWO_WEEKS("twoWeeks"),
    ONE_MONTH("oneMonth"), TWO_MONTHS("twoMonths");
    
    private String value;
    
    private DayCountInterval(String recsDayCountStr) {
        this.value = recsDayCountStr;
    }
    
    public String getValue() {
        return this.value;
    }
    
    /**
     * Tries to match the given string to an actual {@code DayCountInterval} enum value
     * 
     * @param value
     *            String representing the day conut interval
     * @return a {@code DayCountInterval} object if the match is successful or null if no match is found
     */
    public static DayCountInterval fromString(String value) {
        for (DayCountInterval validDayCountInterval : values()) {
            if (validDayCountInterval.getValue().equalsIgnoreCase(value)) {
                return validDayCountInterval;
            }
        }
        
        return null;
    }
}
