/*
 * File: CoolTypeScript.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2007 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *  obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font;

/** Enumeration representing some CoolType codepages
 * Currently we don't do them all, just the six that are required for XDC
 * That's why the class isn't called CoolTypeCodePage
 */
public final class CodePage
{
	private final int mID;
	private final String mName;
	private final CoolTypeScript mScript;

	private CodePage(int id, String name, CoolTypeScript script) {
		mID = id;
		mName = name;
		mScript = script;
	}

	public static final CodePage ROMAN1 = new CodePage(1252, "WinRoman", CoolTypeScript.ROMAN);
	public static final CodePage ROMAN2 = new CodePage(1250, "WinEastEuropeanRoman", CoolTypeScript.EAST_EUROPEAN_ROMAN);
	public static final CodePage JAPANESE = new CodePage(932, "WinJapanese", CoolTypeScript.JAPANESE);
	public static final CodePage KOREAN = new CodePage(949, "WinKorean", CoolTypeScript.KOREAN);
	public static final CodePage SIMPLIFIED_CHINESE = new CodePage(936, "WinSimplifiedChinese", CoolTypeScript.SIMPLIFIED_CHINESE);
	public static final CodePage TRADITIONAL_CHINESE = new CodePage(950, "WinTraditionalChinese", CoolTypeScript.TRADITIONAL_CHINESE);

	public int getID() {
		return mID;
	}

	public String getName() {
		return mName;
	}

	public CoolTypeScript getScript() {
		return mScript;
	}
}
