/*
 *
 *	File: Tag.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

/** Tag manipulation and predefined tags.
 *  
 *<p>Tags are represented internally as ints.</p>
 */

public final class Tag {
  /** tags for font header*/

  public static final int misc_ttcf = string2tag ("ttcf");
  public static final int misc_OTTO;
  public static final int misc_1_0;
  public static final int misc_true = string2tag ("true");


  public static final int table_BASE = 0x42415345;
  public static final int table_CFF  = 0x43464620;
  public static final int table_DSIG = 0x44534947;
  public static final int table_GDEF = 0x47444546;
  public static final int table_GPOS = 0x47504f53;
  public static final int table_GSUB = 0x47535542;
  public static final int table_cmap = 0x636d6170;
  public static final int table_cvt  = 0x63767420;
  public static final int table_head = 0x68656164;
  public static final int table_hhea = 0x68686561;
  public static final int table_hmtx = 0x686d7478;
  public static final int table_fpgm = 0x6670676d;
  public static final int table_glyf = 0x676c7966;
  public static final int table_loca = 0x6c6f6361;
  public static final int table_maxp = 0x6d617870;
  public static final int table_name = 0x6e616d65;
  public static final int table_os2  = 0x4f532f32;   // OS/2
  public static final int table_post = 0x706f7374;
  public static final int table_prep = 0x70726570;
  public static final int table_vhea = 0x76686561;
  public static final int table_vmtx = 0x766d7478;
  public static final int table_kern = 0x6b65726e;
  public static final int table_gasp = 0x67617370;
  public static final int table_LTSH = 0x4c545348;
  public static final int table_VORG = 0x564f5247;
  public static final int table_fond = 0x666f6e64;
  public static final int table_SBST = 0x53425354; // table tag used to add testing data to the output of subsetAndStreamForSWFEmbedding



  /** Arabic */  		    public static final int script_arab;
  /** Armenian */			public static final int script_armn;
  /** Bengali */			public static final int script_beng;
  /** Bopomofo */			public static final int script_bopo;
  /** Braille */			public static final int script_brai;
  /** Canadian Syllabics */	public static final int script_cans;
  /** Cherokee */			public static final int script_cher;
  /** Cyrillic */           public static final int script_cyrl;
  /** Ideographic */		public static final int script_hani;
  /** Default */			public static final int script_DFLT;
  /** Devanagari */			public static final int script_deva;
  /** Ethiopic */			public static final int script_ethi;
  /** Georgian */			public static final int script_geor;
  /** Greek */				public static final int script_grek;
  /** Gujarati */			public static final int script_gujr;
  /** Gurmukhi */			public static final int script_guru;
  /** Hangul Jamo */		public static final int script_jamo;
  /** Hangul */				public static final int script_hang;
  /** Hebrew */				public static final int script_hebr;
  /** Hiragana & Katakana */ public static final int script_kana;
  /** Kannada */			public static final int script_knda;
  /** Khmer */				public static final int script_khmr;
  /** Lao */				public static final int script_lao;
  /** Latin */				public static final int script_latn;
  /** Malayalam */			public static final int script_mlym;
  /** Mongolian */			public static final int script_mong;
  /** Myanmar */			public static final int script_mymr;
  /** Ogham */				public static final int script_ogam;
  /** Oriya */				public static final int script_orya;
  /** Runic */				public static final int script_runr;
  /** Sinhala */			public static final int script_sinh;
  /** Syriac */				public static final int script_syrc;
  /** Tamil */				public static final int script_taml;
  /** Telugu */				public static final int script_telu;
  /** Thaana */				public static final int script_thaa;
  /** Thai */				public static final int script_thai;
  /** Tibetan */			public static final int script_tibt;
  /** Yi */				    public static final int script_yi;

  /** Abaza */				public static final int language_ABA;
  /** Abkhazian */          public static final int language_ABK;
  /** Adyghe */				public static final int language_ADY;
  /** Afrikaans */			public static final int language_AFK;
  /** Afar */				public static final int language_AFR;
  /** Agaw */				public static final int language_AGW;
  /** Altai */				public static final int language_ALT;
  /** Amharic */			public static final int language_AMH;
  /** Arabic */				public static final int language_ARA;
  /** Aari */				public static final int language_ARI;
  /** Arakanese */			public static final int language_ARK;
  /** Assamese */			public static final int language_ASM;
  /** Athapaskan */			public static final int language_ATH;
  /** Avar */				public static final int language_AVR;
  /** Awadhi */				public static final int language_AWA;
  /** Aymara */				public static final int language_AYM;
  /** Azeri */				public static final int language_AZE;
  /** Badaga */				public static final int language_BAD;
  /** Baghelkhandi */			public static final int language_BAG;
  /** Balkar */				public static final int language_BAL;
  /** Baule */				public static final int language_BAU;
  /** Berber */				public static final int language_BBR;
  /** Bench */				public static final int language_BCH;
  /** Bible Cree */			public static final int language_BCR;
  /** Belarussian */			public static final int language_BEL;
  /** Bemba */				public static final int language_BEM;
  /** Bengali */			public static final int language_BEN;
  /** Bulgarian */			public static final int language_BGR;
  /** Bhili */				public static final int language_BHI;
  /** Bhojpuri */			public static final int language_BHO;
  /** Bikol */				public static final int language_BIK;
  /** Bilen */				public static final int language_BIL;
  /** Blackfoot */			public static final int language_BKF;
  /** Balochi */			public static final int language_BLI;
  /** Balante */			public static final int language_BLN;
  /** Balti */				public static final int language_BLT;
  /** Bambara */			public static final int language_BMB;
  /** Bamileke */			public static final int language_BML;
  /** Breton */				public static final int language_BRE;
  /** Brahui */				public static final int language_BRH;
  /** Braj Bhasha */			public static final int language_BRI;
  /** Burmese */			public static final int language_BRM;
  /** Bashkir */			public static final int language_BSH;
  /** Beti */				public static final int language_BTI;
  /** Catalan */			public static final int language_CAT;
  /** Cebuano */			public static final int language_CEB;
  /** Chechen */			public static final int language_CHE;
  /** Chaha Gurage */			public static final int language_CHG;
  /** Chattisgarhi */			public static final int language_CHH;
  /** Chichewa */			public static final int language_CHI;
  /** Chukchi */			public static final int language_CHK;
  /** Chipewyan */			public static final int language_CHP;
  /** Cherokee */			public static final int language_CHR;
  /** Chuvash */			public static final int language_CHU;
  /** Comorian */			public static final int language_CMR;
  /** Coptic */				public static final int language_COP;
  /** Cree */				public static final int language_CRE;
  /** Carrier */			public static final int language_CRR;
  /** Crimean Tatar */			public static final int language_CRT;
  /** Church Slavonic */		public static final int language_CSL;
  /** Czech */				public static final int language_CSY;
  /** Danish */				public static final int language_DAN;
  /** Dargwa */				public static final int language_DAR;
  /** Woods Cree */			public static final int language_DCR;
  /** German (Standard) */		public static final int language_DEU;
  /** Dogri */				public static final int language_DGR;
  /** Dhivehi */			public static final int language_DHV;
  /** Djerma */				public static final int language_DJR;
  /** Dangme */				public static final int language_DNG;
  /** Dinka */				public static final int language_DNK;
  /** Dungan */				public static final int language_DUN;
  /** Dzongkha */			public static final int language_DZN;
  /** Ebira */				public static final int language_EBI;
  /** Eastern Cree */			public static final int language_ECR;
  /** Edo */				public static final int language_EDO;
  /** Efik */				public static final int language_EFI;
  /** Greek */				public static final int language_ELL;
  /** English */			public static final int language_ENG;
  /** Erzya */				public static final int language_ERZ;
  /** Spanish */			public static final int language_ESP;
  /** Estonian */			public static final int language_ETI;
  /** Basque */				public static final int language_EUQ;
  /** Evenki */				public static final int language_EVK;
  /** Even */				public static final int language_EVN;
  /** Ewe */				public static final int language_EWE;
  /** French Antillean */		public static final int language_FAN;
  /** Farsi */				public static final int language_FAR;
  /** Finnish */			public static final int language_FIN;
  /** Fijian */				public static final int language_FJI;
  /** Flemish */			public static final int language_FLE;
  /** Forest Nenets */			public static final int language_FNE;
  /** Fon */				public static final int language_FON;
  /** Faroese */			public static final int language_FOS;
  /** French (Standard) */		public static final int language_FRA;
  /** Frisian */			public static final int language_FRI;
  /** Friulian */			public static final int language_FRL;
  /** Futa */				public static final int language_FTA;
  /** Fulani */				public static final int language_FUL;
  /** Ga */				public static final int language_GAD;
  /** Gaelic */				public static final int language_GAE;
  /** Gagauz */				public static final int language_GAG;
  /** Galician */			public static final int language_GAL;
  /** Garshuni */			public static final int language_GAR;
  /** Garhwali */			public static final int language_GAW;
  /** Geez */				public static final int language_GEZ;
  /** Gilyak */				public static final int language_GIL;
  /** Gumuz */				public static final int language_GMZ;
  /** Gondi */				public static final int language_GON;
  /** Greenlandic */			public static final int language_GRN;
  /** Garo */				public static final int language_GRO;
  /** Guarani */			public static final int language_GUA;
  /** Gujarati */			public static final int language_GUJ;
  /** Haitian */			public static final int language_HAI;
  /** Halam */				public static final int language_HAL;
  /** Harauti */			public static final int language_HAR;
  /** Hausa */				public static final int language_HAU;
  /** Hawaiin */			public static final int language_HAW;
  /** Hammer-Banna */			public static final int language_HBN;
  /** Hiligaynon */			public static final int language_HIL;
  /** Hindi */				public static final int language_HIN;
  /** High Mari */			public static final int language_HMA;
  /** Hindko */				public static final int language_HND;
  /** Ho */				public static final int language_HO;
  /** Harari */				public static final int language_HRI;
  /** Croatian */			public static final int language_HRV;
  /** Hungarian */			public static final int language_HUN;
  /** Armenian */			public static final int language_HYE;
  /** Igbo */				public static final int language_IBO;
  /** Ijo */				public static final int language_IJO;
  /** Ilokano */			public static final int language_ILO;
  /** Indonesian */			public static final int language_IND;
  /** Ingush */				public static final int language_ING;
  /** Inuktitut */			public static final int language_INU;
  /** Irish */				public static final int language_IRI;
  /** Irish Traditional */		public static final int language_IRT;
  /** Icelandic */			public static final int language_ISL;
  /** Inari Sami */			public static final int language_ISM;
  /** Italian */			public static final int language_ITA;
  /** Hebrew */				public static final int language_IWR;
  /** Javanese */			public static final int language_JAV;
  /** Yiddish */			public static final int language_JII;
  /** Japanese */			public static final int language_JAN;
  /** Judezmo */			public static final int language_JUD;
  /** Jula */				public static final int language_JUL;
  /** Kabardian */			public static final int language_KAB;
  /** Kachchi */			public static final int language_KAC;
  /** Kalenjin */			public static final int language_KAL;
  /** Kannada */			public static final int language_KAN;
  /** Karachay */			public static final int language_KAR;
  /** Georgian */			public static final int language_KAT;
  /** Kazakh */				public static final int language_KAZ;
  /** Kebena */				public static final int language_KEB;
  /** Khutsuri Georgian */		public static final int language_KGE;
  /** Khakass */			public static final int language_KHA;
  /** Khanty-Kazim */			public static final int language_KHK;
  /** Khmer */				public static final int language_KHM;
  /** Khanty-Shurishkar */		public static final int language_KHS;
  /** Khanty-Vakhi */			public static final int language_KHV;
  /** Khowar */				public static final int language_KHW;
  /** Kikuyu */				public static final int language_KIK;
  /** Kirghiz */			public static final int language_KIR;
  /** Kisii */				public static final int language_KIS;
  /** Kokni */				public static final int language_KKN;
  /** Kalmyk */				public static final int language_KLM;
  /** Kamba */				public static final int language_KMB;
  /** Kumaoni */			public static final int language_KMN;
  /** Komo */				public static final int language_KMO;
  /** Komso */				public static final int language_KMS;
  /** Kanuri */				public static final int language_KNR;
  /** Kodagu */				public static final int language_KOD;
  /** Konkani */			public static final int language_KOK;
  /** Kikongo */			public static final int language_KON;
  /** Komi-Permyak */			public static final int language_KOP;
  /** Korean */				public static final int language_KOR;
  /** Komi-Zyrian */			public static final int language_KOZ;
  /** Kpelle */				public static final int language_KPL;
  /** Krio */				public static final int language_KRI;
  /** Karakalpak */			public static final int language_KRK;
  /** Karelian */			public static final int language_KRL;
  /** Karaim */				public static final int language_KRM;
  /** Karen */				public static final int language_KRN;
  /** Koorete */			public static final int language_KRT;
  /** Kashmiri */			public static final int language_KSH;
  /** Khasi */				public static final int language_KSI;
  /** Kildin Sami */			public static final int language_KSM;
  /** Kui */				public static final int language_KUI;
  /** Kulvi */				public static final int language_KUL;
  /** Kumyk */				public static final int language_KUM;
  /** Kurdish */			public static final int language_KUR;
  /** Kurukh */				public static final int language_KUU;
  /** Kuy */				public static final int language_KUY;
  /** Koryak */				public static final int language_KYK;
  /** Ladin */				public static final int language_LAD;
  /** Lahuli */				public static final int language_LAH;
  /** Lak */				public static final int language_LAK;
  /** Lambani */			public static final int language_LAM;
  /** Lao */				public static final int language_LAO;
  /** Latin */				public static final int language_LAT;
  /** Laz */				public static final int language_LAZ;
  /** L-Cree */				public static final int language_LCR;
  /** Ladakhi */			public static final int language_LDK;
  /** Lezgi */				public static final int language_LEZ;
  /** Lingala */			public static final int language_LIN;
  /** Low Mari */			public static final int language_LMA;
  /** Limbu */				public static final int language_LMB;
  /** Lomwe */				public static final int language_LMW;
  /** Lower Sorbian */			public static final int language_LSB;
  /** Lule Sami */			public static final int language_LSM;
  /** Lithuanian */			public static final int language_LTH;
  /** Luba */				public static final int language_LUB;
  /** Luganda */			public static final int language_LUG;
  /** Luhya */				public static final int language_LUH;
  /** Luo */				public static final int language_LUO;
  /** Latvian */			public static final int language_LVI;
  /** Majang */				public static final int language_MAJ;
  /** Makua */				public static final int language_MAK;
  /** Malayalam Traditional */		public static final int language_MAL;
  /** Mansi */				public static final int language_MAN;
  /** Marathi */			public static final int language_MAR;
  /** Marwari */			public static final int language_MAW;
  /** Mbundu */				public static final int language_MBN;
  /** Manchu */				public static final int language_MCH;
  /** Moose Cree */			public static final int language_MCR;
  /** Mende */				public static final int language_MDE;
  /** Meen */				public static final int language_MEN;
  /** Mizo */				public static final int language_MIZ;
  /** Macedonian */			public static final int language_MKD;
  /** Male */				public static final int language_MLE;
  /** Malagasy */			public static final int language_MLG;
  /** Malinke */			public static final int language_MLN;
  /** Malayalam Reformed */		public static final int language_MLR;
  /** Malay */				public static final int language_MLY;
  /** Mandinka */			public static final int language_MND;
  /** Mongolian */			public static final int language_MNG;
  /** Manipuri */			public static final int language_MNI;
  /** Maninka */			public static final int language_MNK;
  /** Manx Gaelic */			public static final int language_MNX;
  /** Moksha */				public static final int language_MOK;
  /** Moldavian */			public static final int language_MOL;
  /** Mon */				public static final int language_MON;
  /** Moroccan */			public static final int language_MOR;
  /** Maori */				public static final int language_MRI;
  /** Maithili */			public static final int language_MTH;
  /** Maltese */			public static final int language_MTS;
  /** Mundari */			public static final int language_MUN;
  /** Naga-Assamese */			public static final int language_NAG;
  /** Nanai */				public static final int language_NAN;
  /** Naskapi */			public static final int language_NAS;
  /** N-Cree */				public static final int language_NCR;
  /** Ndebele */			public static final int language_NDB;
  /** Ndonga */				public static final int language_NDG;
  /** Nepali */				public static final int language_NEP;
  /** Newari */				public static final int language_NEW;
  /** Norway House Cree */		public static final int language_NHC;
  /** Nisi */				public static final int language_NIS;
  /** Niuean */				public static final int language_NIU;
  /** Nkole */				public static final int language_NKL;
  /** Dutch */				public static final int language_NLD;
  /** Nogai */				public static final int language_NOG;
  /** Norwegian */			public static final int language_NOR;
  /** Northern Sami */			public static final int language_NSM;
  /** Northern Tai */			public static final int language_NTA;
  /** Esperanto */			public static final int language_NTO;
  /** Nynorsk */			public static final int language_NYN;
  /** Oji-Cree */			public static final int language_OCR;
  /** Ojibway */			public static final int language_OJB;
  /** Oriya */				public static final int language_ORI;
  /** Oromo */				public static final int language_ORO;
  /** Ossetian */			public static final int language_OSS;
  /** Palestinian Aramaic */		public static final int language_PAA;
  /** Pali */				public static final int language_PAL;
  /** Punjabi */			public static final int language_PAN;
  /** Palpa */				public static final int language_PAP;
  /** Pashto */				public static final int language_PAS;
  /** Polytonic Greek */		public static final int language_PGR;
  /** Pilipino */			public static final int language_PIL;
  /** Palaung */			public static final int language_PLG;
  /** Polish */				public static final int language_PLK;
  /** Provencal */			public static final int language_PRO;
  /** Portuguese */			public static final int language_PTG;
  /** Chin */				public static final int language_QIN;
  /** Rajasthani */			public static final int language_RAJ;
  /** R-Cree */				public static final int language_RCR;
  /** Russian Buriat */			public static final int language_RBU;
  /** Riang */				public static final int language_RIA;
  /** Rhaeto-Romanic */			public static final int language_RMS;
  /** Romanian */			public static final int language_ROM;
  /** Romany */				public static final int language_ROY;
  /** Rusyn */				public static final int language_RSY;
  /** Ruanda */				public static final int language_RUA;
  /** Russian */			public static final int language_RUS;
  /** Sadri */				public static final int language_SAD;
  /** Sanskrit */			public static final int language_SAN;
  /** Santali */			public static final int language_SAT;
  /** Sayisi */				public static final int language_SAY;
  /** Sekota */				public static final int language_SEK;
  /** Selkup */				public static final int language_SEL;
  /** Sango */				public static final int language_SGO;
  /** Shan */				public static final int language_SHN;
  /** Sibe */				public static final int language_SIB;
  /** Sidamo */				public static final int language_SID;
  /** Silte Gurage */			public static final int language_SIG;
  /** Skolt Sami */			public static final int language_SKS;
  /** Slovak */				public static final int language_SKY;
  /** Slavey */				public static final int language_SLA;
  /** Slovenian */			public static final int language_SLV;
  /** Somali */				public static final int language_SML;
  /** Samoan */				public static final int language_SMO;
  /** Sena */				public static final int language_SNA;
  /** Sindhi */				public static final int language_SND;
  /** Sinhalese */			public static final int language_SNH;
  /** Soninke */			public static final int language_SNK;
  /** Sodo Gurage */			public static final int language_SOG;
  /** Sotho */				public static final int language_SOT;
  /** Albanian */			public static final int language_SQI;
  /** Serbian */			public static final int language_SRB;
  /** Saraiki */			public static final int language_SRK;
  /** Serer */				public static final int language_SRR;
  /** South Slavey */			public static final int language_SSL;
  /** Southern Sami */			public static final int language_SSM;
  /** Suri */				public static final int language_SUR;
  /** Svan */				public static final int language_SVA;
  /** Swedish */			public static final int language_SVE;
  /** Swadaya Aramaic */		public static final int language_SWA;
  /** Swahili */			public static final int language_SWK;
  /** Swazi */				public static final int language_SWZ;
  /** Sutu */				public static final int language_SXT;
  /** Syriac */				public static final int language_SYR;
  /** Tabasaran */			public static final int language_TAB;
  /** Tajiki */				public static final int language_TAJ;
  /** Tamil */				public static final int language_TAM;
  /** Tatar */				public static final int language_TAT;
  /** TH-Cree */			public static final int language_TCR;
  /** Telugu */				public static final int language_TEL;
  /** Tongan */				public static final int language_TGN;
  /** Tigre */				public static final int language_TGR;
  /** Tigrinya */			public static final int language_TGY;
  /** Thai */				public static final int language_THA;
  /** Tahitian */			public static final int language_THT;
  /** Tibetan */			public static final int language_TIB;
  /** Turkmen */			public static final int language_TKM;
  /** Temne */				public static final int language_TMN;
  /** Tswana */				public static final int language_TNA;
  /** Tundra Nenets */			public static final int language_TNE;
  /** Tonga */				public static final int language_TNG;
  /** Todo */				public static final int language_TOD;
  /** Turkish */			public static final int language_TRK;
  /** Tsonga */				public static final int language_TSG;
  /** Turoyo Aramaic */			public static final int language_TUA;
  /** Tulu */				public static final int language_TUL;
  /** Tuvin */				public static final int language_TUV;
  /** Twi */				public static final int language_TWI;
  /** Udmurt */				public static final int language_UDM;
  /** Ukrainian */			public static final int language_UKR;
  /** Urdu */				public static final int language_URD;
  /** Upper Sorbian */			public static final int language_USB;
  /** Uyghur */				public static final int language_UYG;
  /** Uzbek */				public static final int language_UZB;
  /** Venda */				public static final int language_VEN;
  /** Vietnamese */			public static final int language_VIT;
  /** Wa */				public static final int language_WA;
  /** Wagdi */				public static final int language_WAG;
  /** West-Cree */			public static final int language_WCR;
  /** Welsh */				public static final int language_WEL;
  /** Wolof */				public static final int language_WLF;
  /** Xhosa */				public static final int language_XHS;
  /** Yakut */				public static final int language_YAK;
  /** Yoruba */				public static final int language_YBA;
  /** Y-Cree */				public static final int language_YCR;
  /** Yi Classic */			public static final int language_YIC;
  /** Yi Modern */			public static final int language_YIM;
  /** Chinese Phonetic */		public static final int language_ZHP;
  /** Chinese Simplified */		public static final int language_ZHS;
  /** Chinese Traditional */		public static final int language_ZHT;
  /** Chinese Hong Kong */    public static final int language_ZHH;
  /** Zande */				public static final int language_ZND;
  /** Zulu */				public static final int language_ZUL;


  /** Baseline tags */
  /** hang */                           public static final int baseline_hang;
  /** icfb */				public static final int baseline_icfb;
  /** icft */				public static final int baseline_icft;
  /** ideo */				public static final int baseline_ideo;
  /** idtp */				public static final int baseline_idtp;
  /** math */				public static final int baseline_math;
  /** romn */				public static final int baseline_romn;

  /** Feature tags */
  /** Access All Alternates */		public static final int feature_aalt;
  /** Above-base Forms */		public static final int feature_abvf;
  /** Above-base Mark Positioning */	public static final int feature_abvm;
  /** Above-base Substitutions */       public static final int feature_abvs;
  /** Alternative Fractions */          public static final int feature_afrc;
  /** Akhands */			public static final int feature_akhn;
  /** Below-base Forms */		public static final int feature_blwf;
  /** Below-base Mark Positioning */	public static final int feature_blwm;
  /** Below-base Substitutions */	public static final int feature_blws;
  /** Contextual Alternates */		public static final int feature_calt;
  /** Case-Sensitive Forms */           public static final int feature_case;
  /** Glyph Composition / Decomposition */public static final int feature_ccmp;
  /** Contextual Ligatures */		  public static final int feature_clig;
  /** Capital Spacing */		  public static final int feature_cpsp;
  /** Contextual Swash */		  public static final int feature_cswh;
  /** Cursive Positioning */		  public static final int feature_curs;
  /** Small Capitals From Capitals */	  public static final int feature_c2sc;
  /** Petite Capitals From Capitals */	  public static final int feature_c2pc;
  /** Distances */			  public static final int feature_dist;
  /** Discretionary Ligatures */	  public static final int feature_dlig;
  /** Denominators */			  public static final int feature_dnom;
  /** Expert Forms */			  public static final int feature_expt;
  /** Final Glyph on Line Alternates */	  public static final int feature_falt;
  /** Terminal Forms #2 */		  public static final int feature_fin2;
  /** Terminal Forms #3 */		  public static final int feature_fin3;
  /** Terminal Forms */			  public static final int feature_fina;
  /** Fractions */			  public static final int feature_frac;
  /** Full Widths */			  public static final int feature_fwid;
  /** Half Forms */			  public static final int feature_half;
  /** Halant Forms */			  public static final int feature_haln;
  /** Alternate Half Widths */		  public static final int feature_halt;
  /** Historical Forms */		  public static final int feature_hist;
  /** Horizontal Kana Alternates */	  public static final int feature_hkna;
  /** Historical Ligatures */		  public static final int feature_hlig;
  /** Hangul */				  public static final int feature_hngl;
  /** Half Widths */			  public static final int feature_hwid;
  /** Initial Forms */			  public static final int feature_init;
  /** Isolated Forms */			  public static final int feature_isol;
  /** Italics */			  public static final int feature_ital;
  /** Justification Alternates */	  public static final int feature_jalt;
  /** JIS78 Forms */			  public static final int feature_jp78;
  /** JIS83 Forms */			  public static final int feature_jp83;
  /** JIS90 Forms */			  public static final int feature_jp90;
  /** Kerning */			  public static final int feature_kern;
  /** Left Bounds */			  public static final int feature_lfbd;
  /** Standard Ligatures */		  public static final int feature_liga;
  /** Leading Jamo Forms */		  public static final int feature_ljmo;
  /** Lining Figures */			  public static final int feature_lnum;
  /** Localized Forms */		  public static final int feature_locl;
  /** Mark Positioning */		  public static final int feature_mark;
  /** Medial Forms #2 */		  public static final int feature_med2;
  /** Medial Forms */			  public static final int feature_medi;
  /** Mathematical Greek */		  public static final int feature_mgrk;
  /** Mark to Mark Positioning */	  public static final int feature_mkmk;
  /** Mark Positioning via Substitution */public static final int feature_mset;
  /** Alternate Annotation Forms */	  public static final int feature_nalt;
  /** NLC Kanji Forms */		  public static final int feature_nlck;
  /** Nukta Forms */			  public static final int feature_nukt;
  /** Numerators */			  public static final int feature_numr;
  /** Oldstyle Figures */		  public static final int feature_onum;
  /** Optical Bounds */			  public static final int feature_opbd;
  /** Ordinals */			  public static final int feature_ordn;
  /** Ornaments */			  public static final int feature_ornm;
  /** Proportional Alternate Widths */	  public static final int feature_palt;
  /** Petite Capitals */		  public static final int feature_pcap;
  /** Proportional Figures */		  public static final int feature_pnum;
  /** Pre-Base Forms */			  public static final int feature_pref;
  /** Pre-base Substitutions */		  public static final int feature_pres;
  /** Post-base Forms */		  public static final int feature_pstf;
  /** Post-base Substitutions */	  public static final int feature_psts;
  /** Proportional Widths */		  public static final int feature_pwid;
  /** Quarter Widths */			  public static final int feature_qwid;
  /** Randomize */			  public static final int feature_rand;
  /** Required Ligatures */		  public static final int feature_rlig;
  /** Reph Forms */			  public static final int feature_rphf;
  /** Right Bounds */			  public static final int feature_rtbd;
  /** Right-to-left alternates */	  public static final int feature_rtla;
  /** Ruby Notation Forms */		  public static final int feature_ruby;
  /** Stylistic Alternates */		  public static final int feature_salt;
  /** Scientific Inferiors */		  public static final int feature_sinf;
  /** Optical size */			  public static final int feature_size;
  /** Small Capitals */			  public static final int feature_smcp;
  /** Simplified Forms */		  public static final int feature_smpl;
  /** Stylistic Set 01 */		  public static final int feature_ss01;
  /** Stylistic Set 02 */		  public static final int feature_ss02;
  /** Stylistic Set 03 */		  public static final int feature_ss03;
  /** Stylistic Set 04 */		  public static final int feature_ss04;
  /** Stylistic Set 05 */		  public static final int feature_ss05;
  /** Stylistic Set 06 */		  public static final int feature_ss06;
  /** Stylistic Set 07 */		  public static final int feature_ss07;
  /** Stylistic Set 08 */		  public static final int feature_ss08;
  /** Stylistic Set 09 */		  public static final int feature_ss09;
  /** Stylistic Set 10 */		  public static final int feature_ss10;
  /** Stylistic Set 11 */		  public static final int feature_ss11;
  /** Stylistic Set 12 */		  public static final int feature_ss12;
  /** Stylistic Set 13 */		  public static final int feature_ss13;
  /** Stylistic Set 14 */		  public static final int feature_ss14;
  /** Stylistic Set 15 */		  public static final int feature_ss15;
  /** Stylistic Set 16 */		  public static final int feature_ss16;
  /** Stylistic Set 17 */		  public static final int feature_ss17;
  /** Stylistic Set 18 */		  public static final int feature_ss18;
  /** Stylistic Set 19 */		  public static final int feature_ss19;
  /** Stylistic Set 20 */		  public static final int feature_ss20;
  /** Subscript */			  public static final int feature_subs;
  /** Superscript */			  public static final int feature_sups;
  /** Swash */				  public static final int feature_swsh;
  /** Titling */			  public static final int feature_titl;
  /** Trailing Jamo Forms */		  public static final int feature_tjmo;
  /** Traditional Name Forms */		  public static final int feature_tnam;
  /** Tabular Figures */		  public static final int feature_tnum;
  /** Traditional Forms */		  public static final int feature_trad;
  /** Third Widths */			  public static final int feature_twid;
  /** Unicase */			  public static final int feature_unic;
  /** Alternate Vertical Metrics */	  public static final int feature_valt;
  /** Vattu Variants */			  public static final int feature_vatu;
  /** Vertical Writing */		  public static final int feature_vert;
  /** Alternate Vertical Half Metrics */  public static final int feature_vhal;
  /** Vowel Jamo Forms */		  public static final int feature_vjmo;
  /** Vertical Kana Alternates */	  public static final int feature_vkna;
  /** Vertical Kerning */		  public static final int feature_vkrn;
  /** Proportional Alternate Vertical Metrics */public static final int feature_vpal;
  /** Vertical Alternates and Rotation */ public static final int feature_vrt2;
  /** Slashed Zero */			  public static final int feature_zero;

  /** Required feature */    public static final int feature_REQUIRED = 0;

  /**
   * Given a string, return the corresponding tag.
   * 
   * @param s 
   * must not be null; 
   * if the string is shorted than four characters, spaces (U+0020) are added as needed;
   * if the string is longer than four characters, then only the first four characters
   * are considered; 
   * all characters must be in the range U+0000..U+00FF.
   * 
   * @return the tag corresponding to <code>s</code>
   */
  public static int string2tag (String s) {
    String t = s + "    ";
    int result = 0;
    for (int i = 0; i < 4; i++) {
      result = (result << 8) | t.charAt (i); }
    return result;
  }

  /**
   * Given a tag, return the string corresponding to it.
   * 
   * @param tag
   * @return the string corresponding to <code>tag</code>.
   */
  public static String tag2string (int tag) {
    char[] chars = new char[4];
    for (int i = 3; i >= 0; i--) {
      chars [i] = (char)(tag & 0xff); 
      if (chars [i] == 0x0) {
        chars [i] = 0x20; }
      tag = tag >> 8; }
    return new String (chars);
  }

  static {
//  misc_ttcf = string2tag ("ttcf");
    misc_OTTO = string2tag ("OTTO");
    misc_1_0  = 0x00010000;

    script_arab = string2tag ("arab");
    script_armn = string2tag ("armn");
    script_beng = string2tag ("beng");
    script_bopo = string2tag ("bopo");
    script_brai = string2tag ("brai");
    script_cans = string2tag ("cans");
    script_cher = string2tag ("cher");
    script_cyrl = string2tag ("cyrl");
    script_hani = string2tag ("hani");
    script_DFLT = string2tag ("DFLT");
    script_deva = string2tag ("deva");
    script_ethi = string2tag ("ethi");
    script_geor = string2tag ("geor");
    script_grek = string2tag ("grek");
    script_gujr = string2tag ("gujr");
    script_guru = string2tag ("guru");
    script_jamo = string2tag ("jamo");
    script_hang = string2tag ("hang");
    script_hebr = string2tag ("hebr");
    script_kana = string2tag ("kana");
    script_knda = string2tag ("knda");
    script_khmr = string2tag ("khmr");
    script_lao  = string2tag ("lao");
    script_latn = string2tag ("latn");
    script_mlym = string2tag ("mlym");
    script_mong = string2tag ("mong");
    script_mymr = string2tag ("mymr");
    script_ogam = string2tag ("ogam");
    script_orya = string2tag ("orya");
    script_runr = string2tag ("runr");
    script_sinh = string2tag ("sinh");
    script_syrc = string2tag ("syrc");
    script_taml = string2tag ("taml");
    script_telu = string2tag ("telu");
    script_thaa = string2tag ("thaa");
    script_thai = string2tag ("thai");
    script_tibt = string2tag ("tibt");
    script_yi   = string2tag ("yi");

    language_ABA = string2tag ("ABA");
    language_ABK = string2tag ("ABK");
    language_ADY = string2tag ("ADY");
    language_AFK = string2tag ("AFK");
    language_AFR = string2tag ("AFR");
    language_AGW = string2tag ("AGW");
    language_ALT = string2tag ("ALT");
    language_AMH = string2tag ("AMH");
    language_ARA = string2tag ("ARA");
    language_ARI = string2tag ("ARI");
    language_ARK = string2tag ("ARK");
    language_ASM = string2tag ("ASM");
    language_ATH = string2tag ("ATH");
    language_AVR = string2tag ("AVR");
    language_AWA = string2tag ("AWA");
    language_AYM = string2tag ("AYM");
    language_AZE = string2tag ("AZE");
    language_BAD = string2tag ("BAD");
    language_BAG = string2tag ("BAG");
    language_BAL = string2tag ("BAL");
    language_BAU = string2tag ("BAU");
    language_BBR = string2tag ("BBR");
    language_BCH = string2tag ("BCH");
    language_BCR = string2tag ("BCR");
    language_BEL = string2tag ("BEL");
    language_BEM = string2tag ("BEM");
    language_BEN = string2tag ("BEN");
    language_BGR = string2tag ("BGR");
    language_BHI = string2tag ("BHI");
    language_BHO = string2tag ("BHO");
    language_BIK = string2tag ("BIK");
    language_BIL = string2tag ("BIL");
    language_BKF = string2tag ("BKF");
    language_BLI = string2tag ("BLI");
    language_BLN = string2tag ("BLN");
    language_BLT = string2tag ("BLT");
    language_BMB = string2tag ("BMB");
    language_BML = string2tag ("BML");
    language_BRE = string2tag ("BRE");
    language_BRH = string2tag ("BRH");
    language_BRI = string2tag ("BRI");
    language_BRM = string2tag ("BRM");
    language_BSH = string2tag ("BSH");
    language_BTI = string2tag ("BTI");
    language_CAT = string2tag ("CAT");
    language_CEB = string2tag ("CEB");
    language_CHE = string2tag ("CHE");
    language_CHG = string2tag ("CHG");
    language_CHH = string2tag ("CHH");
    language_CHI = string2tag ("CHI");
    language_CHK = string2tag ("CHK");
    language_CHP = string2tag ("CHP");
    language_CHR = string2tag ("CHR");
    language_CHU = string2tag ("CHU");
    language_CMR = string2tag ("CMR");
    language_COP = string2tag ("COP");
    language_CRE = string2tag ("CRE");
    language_CRR = string2tag ("CRR");
    language_CRT = string2tag ("CRT");
    language_CSL = string2tag ("CSL");
    language_CSY = string2tag ("CSY");
    language_DAN = string2tag ("DAN");
    language_DAR = string2tag ("DAR");
    language_DCR = string2tag ("DCR");
    language_DEU = string2tag ("DEU");
    language_DGR = string2tag ("DGR");
    language_DHV = string2tag ("DHV");
    language_DJR = string2tag ("DJR");
    language_DNG = string2tag ("DNG");
    language_DNK = string2tag ("DNK");
    language_DUN = string2tag ("DUN");
    language_DZN = string2tag ("DZN");
    language_EBI = string2tag ("EBI");
    language_ECR = string2tag ("ECR");
    language_EDO = string2tag ("EDO");
    language_EFI = string2tag ("EFI");
    language_ELL = string2tag ("ELL");
    language_ENG = string2tag ("ENG");
    language_ERZ = string2tag ("ERZ");
    language_ESP = string2tag ("ESP");
    language_ETI = string2tag ("ETI");
    language_EUQ = string2tag ("EUQ");
    language_EVK = string2tag ("EVK");
    language_EVN = string2tag ("EVN");
    language_EWE = string2tag ("EWE");
    language_FAN = string2tag ("FAN");
    language_FAR = string2tag ("FAR");
    language_FIN = string2tag ("FIN");
    language_FJI = string2tag ("FJI");
    language_FLE = string2tag ("FLE");
    language_FNE = string2tag ("FNE");
    language_FON = string2tag ("FON");
    language_FOS = string2tag ("FOS");
    language_FRA = string2tag ("FRA");
    language_FRI = string2tag ("FRI");
    language_FRL = string2tag ("FRL");
    language_FTA = string2tag ("FTA");
    language_FUL = string2tag ("FUL");
    language_GAD = string2tag ("GAD");
    language_GAE = string2tag ("GAE");
    language_GAG = string2tag ("GAG");
    language_GAL = string2tag ("GAL");
    language_GAR = string2tag ("GAR");
    language_GAW = string2tag ("GAW");
    language_GEZ = string2tag ("GEZ");
    language_GIL = string2tag ("GIL");
    language_GMZ = string2tag ("GMZ");
    language_GON = string2tag ("GON");
    language_GRN = string2tag ("GRN");
    language_GRO = string2tag ("GRO");
    language_GUA = string2tag ("GUA");
    language_GUJ = string2tag ("GUJ");
    language_HAI = string2tag ("HAI");
    language_HAL = string2tag ("HAL");
    language_HAR = string2tag ("HAR");
    language_HAU = string2tag ("HAU");
    language_HAW = string2tag ("HAW");
    language_HBN = string2tag ("HBN");
    language_HIL = string2tag ("HIL");
    language_HIN = string2tag ("HIN");
    language_HMA = string2tag ("HMA");
    language_HND = string2tag ("HND");
    language_HO = string2tag ("HO");
    language_HRI = string2tag ("HRI");
    language_HRV = string2tag ("HRV");
    language_HUN = string2tag ("HUN");
    language_HYE = string2tag ("HYE");
    language_IBO = string2tag ("IBO");
    language_IJO = string2tag ("IJO");
    language_ILO = string2tag ("ILO");
    language_IND = string2tag ("IND");
    language_ING = string2tag ("ING");
    language_INU = string2tag ("INU");
    language_IRI = string2tag ("IRI");
    language_IRT = string2tag ("IRT");
    language_ISL = string2tag ("ISL");
    language_ISM = string2tag ("ISM");
    language_ITA = string2tag ("ITA");
    language_IWR = string2tag ("IWR");
    language_JAV = string2tag ("JAV");
    language_JII = string2tag ("JII");
    language_JAN = string2tag ("JAN");
    language_JUD = string2tag ("JUD");
    language_JUL = string2tag ("JUL");
    language_KAB = string2tag ("KAB");
    language_KAC = string2tag ("KAC");
    language_KAL = string2tag ("KAL");
    language_KAN = string2tag ("KAN");
    language_KAR = string2tag ("KAR");
    language_KAT = string2tag ("KAT");
    language_KAZ = string2tag ("KAZ");
    language_KEB = string2tag ("KEB");
    language_KGE = string2tag ("KGE");
    language_KHA = string2tag ("KHA");
    language_KHK = string2tag ("KHK");
    language_KHM = string2tag ("KHM");
    language_KHS = string2tag ("KHS");
    language_KHV = string2tag ("KHV");
    language_KHW = string2tag ("KHW");
    language_KIK = string2tag ("KIK");
    language_KIR = string2tag ("KIR");
    language_KIS = string2tag ("KIS");
    language_KKN = string2tag ("KKN");
    language_KLM = string2tag ("KLM");
    language_KMB = string2tag ("KMB");
    language_KMN = string2tag ("KMN");
    language_KMO = string2tag ("KMO");
    language_KMS = string2tag ("KMS");
    language_KNR = string2tag ("KNR");
    language_KOD = string2tag ("KOD");
    language_KOK = string2tag ("KOK");
    language_KON = string2tag ("KON");
    language_KOP = string2tag ("KOP");
    language_KOR = string2tag ("KOR");
    language_KOZ = string2tag ("KOZ");
    language_KPL = string2tag ("KPL");
    language_KRI = string2tag ("KRI");
    language_KRK = string2tag ("KRK");
    language_KRL = string2tag ("KRL");
    language_KRM = string2tag ("KRM");
    language_KRN = string2tag ("KRN");
    language_KRT = string2tag ("KRT");
    language_KSH = string2tag ("KSH");
    language_KSI = string2tag ("KSI");
    language_KSM = string2tag ("KSM");
    language_KUI = string2tag ("KUI");
    language_KUL = string2tag ("KUL");
    language_KUM = string2tag ("KUM");
    language_KUR = string2tag ("KUR");
    language_KUU = string2tag ("KUU");
    language_KUY = string2tag ("KUY");
    language_KYK = string2tag ("KYK");
    language_LAD = string2tag ("LAD");
    language_LAH = string2tag ("LAH");
    language_LAK = string2tag ("LAK");
    language_LAM = string2tag ("LAM");
    language_LAO = string2tag ("LAO");
    language_LAT = string2tag ("LAT");
    language_LAZ = string2tag ("LAZ");
    language_LCR = string2tag ("LCR");
    language_LDK = string2tag ("LDK");
    language_LEZ = string2tag ("LEZ");
    language_LIN = string2tag ("LIN");
    language_LMA = string2tag ("LMA");
    language_LMB = string2tag ("LMB");
    language_LMW = string2tag ("LMW");
    language_LSB = string2tag ("LSB");
    language_LSM = string2tag ("LSM");
    language_LTH = string2tag ("LTH");
    language_LUB = string2tag ("LUB");
    language_LUG = string2tag ("LUG");
    language_LUH = string2tag ("LUH");
    language_LUO = string2tag ("LUO");
    language_LVI = string2tag ("LVI");
    language_MAJ = string2tag ("MAJ");
    language_MAK = string2tag ("MAK");
    language_MAL = string2tag ("MAL");
    language_MAN = string2tag ("MAN");
    language_MAR = string2tag ("MAR");
    language_MAW = string2tag ("MAW");
    language_MBN = string2tag ("MBN");
    language_MCH = string2tag ("MCH");
    language_MCR = string2tag ("MCR");
    language_MDE = string2tag ("MDE");
    language_MEN = string2tag ("MEN");
    language_MIZ = string2tag ("MIZ");
    language_MKD = string2tag ("MKD");
    language_MLE = string2tag ("MLE");
    language_MLG = string2tag ("MLG");
    language_MLN = string2tag ("MLN");
    language_MLR = string2tag ("MLR");
    language_MLY = string2tag ("MLY");
    language_MND = string2tag ("MND");
    language_MNG = string2tag ("MNG");
    language_MNI = string2tag ("MNI");
    language_MNK = string2tag ("MNK");
    language_MNX = string2tag ("MNX");
    language_MOK = string2tag ("MOK");
    language_MOL = string2tag ("MOL");
    language_MON = string2tag ("MON");
    language_MOR = string2tag ("MOR");
    language_MRI = string2tag ("MRI");
    language_MTH = string2tag ("MTH");
    language_MTS = string2tag ("MTS");
    language_MUN = string2tag ("MUN");
    language_NAG = string2tag ("NAG");
    language_NAN = string2tag ("NAN");
    language_NAS = string2tag ("NAS");
    language_NCR = string2tag ("NCR");
    language_NDB = string2tag ("NDB");
    language_NDG = string2tag ("NDG");
    language_NEP = string2tag ("NEP");
    language_NEW = string2tag ("NEW");
    language_NHC = string2tag ("NHC");
    language_NIS = string2tag ("NIS");
    language_NIU = string2tag ("NIU");
    language_NKL = string2tag ("NKL");
    language_NLD = string2tag ("NLD");
    language_NOG = string2tag ("NOG");
    language_NOR = string2tag ("NOR");
    language_NSM = string2tag ("NSM");
    language_NTA = string2tag ("NTA");
    language_NTO = string2tag ("NTO");
    language_NYN = string2tag ("NYN");
    language_OCR = string2tag ("OCR");
    language_OJB = string2tag ("OJB");
    language_ORI = string2tag ("ORI");
    language_ORO = string2tag ("ORO");
    language_OSS = string2tag ("OSS");
    language_PAA = string2tag ("PAA");
    language_PAL = string2tag ("PAL");
    language_PAN = string2tag ("PAN");
    language_PAP = string2tag ("PAP");
    language_PAS = string2tag ("PAS");
    language_PGR = string2tag ("PGR");
    language_PIL = string2tag ("PIL");
    language_PLG = string2tag ("PLG");
    language_PLK = string2tag ("PLK");
    language_PRO = string2tag ("PRO");
    language_PTG = string2tag ("PTG");
    language_QIN = string2tag ("QIN");
    language_RAJ = string2tag ("RAJ");
    language_RCR = string2tag ("RCR");
    language_RBU = string2tag ("RBU");
    language_RIA = string2tag ("RIA");
    language_RMS = string2tag ("RMS");
    language_ROM = string2tag ("ROM");
    language_ROY = string2tag ("ROY");
    language_RSY = string2tag ("RSY");
    language_RUA = string2tag ("RUA");
    language_RUS = string2tag ("RUS");
    language_SAD = string2tag ("SAD");
    language_SAN = string2tag ("SAN");
    language_SAT = string2tag ("SAT");
    language_SAY = string2tag ("SAY");
    language_SEK = string2tag ("SEK");
    language_SEL = string2tag ("SEL");
    language_SGO = string2tag ("SGO");
    language_SHN = string2tag ("SHN");
    language_SIB = string2tag ("SIB");
    language_SID = string2tag ("SID");
    language_SIG = string2tag ("SIG");
    language_SKS = string2tag ("SKS");
    language_SKY = string2tag ("SKY");
    language_SLA = string2tag ("SLA");
    language_SLV = string2tag ("SLV");
    language_SML = string2tag ("SML");
    language_SMO = string2tag ("SMO");
    language_SNA = string2tag ("SNA");
    language_SND = string2tag ("SND");
    language_SNH = string2tag ("SNH");
    language_SNK = string2tag ("SNK");
    language_SOG = string2tag ("SOG");
    language_SOT = string2tag ("SOT");
    language_SQI = string2tag ("SQI");
    language_SRB = string2tag ("SRB");
    language_SRK = string2tag ("SRK");
    language_SRR = string2tag ("SRR");
    language_SSL = string2tag ("SSL");
    language_SSM = string2tag ("SSM");
    language_SUR = string2tag ("SUR");
    language_SVA = string2tag ("SVA");
    language_SVE = string2tag ("SVE");
    language_SWA = string2tag ("SWA");
    language_SWK = string2tag ("SWK");
    language_SWZ = string2tag ("SWZ");
    language_SXT = string2tag ("SXT");
    language_SYR = string2tag ("SYR");
    language_TAB = string2tag ("TAB");
    language_TAJ = string2tag ("TAJ");
    language_TAM = string2tag ("TAM");
    language_TAT = string2tag ("TAT");
    language_TCR = string2tag ("TCR");
    language_TEL = string2tag ("TEL");
    language_TGN = string2tag ("TGN");
    language_TGR = string2tag ("TGR");
    language_TGY = string2tag ("TGY");
    language_THA = string2tag ("THA");
    language_THT = string2tag ("THT");
    language_TIB = string2tag ("TIB");
    language_TKM = string2tag ("TKM");
    language_TMN = string2tag ("TMN");
    language_TNA = string2tag ("TNA");
    language_TNE = string2tag ("TNE");
    language_TNG = string2tag ("TNG");
    language_TOD = string2tag ("TOD");
    language_TRK = string2tag ("TRK");
    language_TSG = string2tag ("TSG");
    language_TUA = string2tag ("TUA");
    language_TUL = string2tag ("TUL");
    language_TUV = string2tag ("TUV");
    language_TWI = string2tag ("TWI");
    language_UDM = string2tag ("UDM");
    language_UKR = string2tag ("UKR");
    language_URD = string2tag ("URD");
    language_USB = string2tag ("USB");
    language_UYG = string2tag ("UYG");
    language_UZB = string2tag ("UZB");
    language_VEN = string2tag ("VEN");
    language_VIT = string2tag ("VIT");
    language_WA = string2tag ("WA");
    language_WAG = string2tag ("WAG");
    language_WCR = string2tag ("WCR");
    language_WEL = string2tag ("WEL");
    language_WLF = string2tag ("WLF");
    language_XHS = string2tag ("XHS");
    language_YAK = string2tag ("YAK");
    language_YBA = string2tag ("YBA");
    language_YCR = string2tag ("YCR");
    language_YIC = string2tag ("YIC");
    language_YIM = string2tag ("YIM");
    language_ZHP = string2tag ("ZHP");
    language_ZHS = string2tag ("ZHS");
    language_ZHT = string2tag ("ZHT");
    language_ZHH = string2tag ("ZHH");
    language_ZND = string2tag ("ZND");
    language_ZUL = string2tag ("ZUL");

    baseline_hang = string2tag ("hang");
    baseline_icfb = string2tag ("icfb");
    baseline_icft = string2tag ("icft");
    baseline_ideo = string2tag ("ideo");
    baseline_idtp = string2tag ("idtp");
    baseline_math = string2tag ("math");
    baseline_romn = string2tag ("romn");

    feature_aalt = string2tag ("aalt");
    feature_abvf = string2tag ("abvf");
    feature_abvm = string2tag ("abvm");
    feature_abvs = string2tag ("abvs");
    feature_afrc = string2tag ("afrc");
    feature_akhn = string2tag ("akhn");
    feature_blwf = string2tag ("blwf");
    feature_blwm = string2tag ("blwm");
    feature_blws = string2tag ("blws");
    feature_calt = string2tag ("calt");
    feature_case = string2tag ("case");
    feature_ccmp = string2tag ("ccmp");
    feature_clig = string2tag ("clig");
    feature_cpsp = string2tag ("cpsp");
    feature_cswh = string2tag ("cswh");
    feature_curs = string2tag ("curs");
    feature_c2sc = string2tag ("c2sc");
    feature_c2pc = string2tag ("c2pc");
    feature_dist = string2tag ("dist");
    feature_dlig = string2tag ("dlig");
    feature_dnom = string2tag ("dnom");
    feature_expt = string2tag ("expt");
    feature_falt = string2tag ("falt");
    feature_fin2 = string2tag ("fin2");
    feature_fin3 = string2tag ("fin3");
    feature_fina = string2tag ("fina");
    feature_frac = string2tag ("frac");
    feature_fwid = string2tag ("fwid");
    feature_half = string2tag ("half");
    feature_haln = string2tag ("haln");
    feature_halt = string2tag ("halt");
    feature_hist = string2tag ("hist");
    feature_hkna = string2tag ("hkna");
    feature_hlig = string2tag ("hlig");
    feature_hngl = string2tag ("hngl");
    feature_hwid = string2tag ("hwid");
    feature_init = string2tag ("init");
    feature_isol = string2tag ("isol");
    feature_ital = string2tag ("ital");
    feature_jalt = string2tag ("jalt");
    feature_jp78 = string2tag ("jp78");
    feature_jp83 = string2tag ("jp83");
    feature_jp90 = string2tag ("jp90");
    feature_kern = string2tag ("kern");
    feature_lfbd = string2tag ("lfbd");
    feature_liga = string2tag ("liga");
    feature_ljmo = string2tag ("ljmo");
    feature_lnum = string2tag ("lnum");
    feature_locl = string2tag ("locl");
    feature_mark = string2tag ("mark");
    feature_med2 = string2tag ("med2");
    feature_medi = string2tag ("medi");
    feature_mgrk = string2tag ("mgrk");
    feature_mkmk = string2tag ("mkmk");
    feature_mset = string2tag ("mset");
    feature_nalt = string2tag ("nalt");
    feature_nlck = string2tag ("nlck");
    feature_nukt = string2tag ("nukt");
    feature_numr = string2tag ("numr");
    feature_onum = string2tag ("onum");
    feature_opbd = string2tag ("opbd");
    feature_ordn = string2tag ("ordn");
    feature_ornm = string2tag ("ornm");
    feature_palt = string2tag ("palt");
    feature_pcap = string2tag ("pcap");
    feature_pnum = string2tag ("pnum");
    feature_pref = string2tag ("pref");
    feature_pres = string2tag ("pres");
    feature_pstf = string2tag ("pstf");
    feature_psts = string2tag ("psts");
    feature_pwid = string2tag ("pwid");
    feature_qwid = string2tag ("qwid");
    feature_rand = string2tag ("rand");
    feature_rlig = string2tag ("rlig");
    feature_rphf = string2tag ("rphf");
    feature_rtbd = string2tag ("rtbd");
    feature_rtla = string2tag ("rtla");
    feature_ruby = string2tag ("ruby");
    feature_salt = string2tag ("salt");
    feature_sinf = string2tag ("sinf");
    feature_size = string2tag ("size");
    feature_smcp = string2tag ("smcp");
    feature_smpl = string2tag ("smpl");
    feature_ss01 = string2tag ("ss01");
    feature_ss02 = string2tag ("ss02");
    feature_ss03 = string2tag ("ss03");
    feature_ss04 = string2tag ("ss04");
    feature_ss05 = string2tag ("ss05");
    feature_ss06 = string2tag ("ss06");
    feature_ss07 = string2tag ("ss07");
    feature_ss08 = string2tag ("ss08");
    feature_ss09 = string2tag ("ss09");
    feature_ss10 = string2tag ("ss10");
    feature_ss11 = string2tag ("ss11");
    feature_ss12 = string2tag ("ss12");
    feature_ss13 = string2tag ("ss13");
    feature_ss14 = string2tag ("ss14");
    feature_ss15 = string2tag ("ss15");
    feature_ss16 = string2tag ("ss16");
    feature_ss17 = string2tag ("ss17");
    feature_ss18 = string2tag ("ss18");
    feature_ss19 = string2tag ("ss19");
    feature_ss20 = string2tag ("ss20");
    feature_subs = string2tag ("subs");
    feature_sups = string2tag ("sups");
    feature_swsh = string2tag ("swsh");
    feature_titl = string2tag ("titl");
    feature_tjmo = string2tag ("tjmo");
    feature_tnam = string2tag ("tnam");
    feature_tnum = string2tag ("tnum");
    feature_trad = string2tag ("trad");
    feature_twid = string2tag ("twid");
    feature_unic = string2tag ("unic");
    feature_valt = string2tag ("valt");
    feature_vatu = string2tag ("vatu");
    feature_vert = string2tag ("vert");
    feature_vhal = string2tag ("vhal");
    feature_vjmo = string2tag ("vjmo");
    feature_vkna = string2tag ("vkna");
    feature_vkrn = string2tag ("vkrn");
    feature_vpal = string2tag ("vpal");
    feature_vrt2 = string2tag ("vrt2");
    feature_zero = string2tag ("zero");
  }
}
