/*
 * File: HangulFormatter.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;



final public class HangulFormatter extends GenericFormatter {
  
  private boolean isL (int ch) {
    return 0x1100 <= ch && ch < 0x1100 + 19;
  }
  
  private boolean isV (int ch) {
    return 0x1161 <= ch && ch < 0x1161 + 21;
  }
  
  private boolean isT (int ch) {
    return 0x11a7 <= ch && ch < 0x11a7 + 28;
  }

  private boolean isLV (int ch) {
    return (0xac00 <= ch) && (ch < 0xac00 + 11172) && ((ch - 0xac00) % 28 == 0);
  }
  
  public int firstPass (AttributedRun run, int start, int limit) {
    // start < limit
    // elements in [start, limit[ are characters
    
    int current = start;
    
    int pendingChar = run.elementAt (current);      
    current++;
    
    while (current < limit) {
      int currentChar = run.elementAt (current);
      if (isL (pendingChar) && isV (currentChar)) {
        pendingChar = 0xac00 + ((pendingChar - 0x1100) * 21 + (currentChar - 0x1161)) * 28;
        run.replace (current - 1, current + 1, pendingChar);
        limit--; }
        
      else if (isLV (pendingChar) && isT (currentChar)) {
        pendingChar = pendingChar + (currentChar - 0x11a7);
        run.replace (current - 1, current + 1, pendingChar);
        limit--; }
      
      else {
        pendingChar = currentChar;
        current++; }}
   
    return super.firstPass (run, start, limit);
  }
}
      

