/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

import java.util.Collections;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A simple collection of activities usually aggregated from several activity streams.
 */
@ProviderType
public interface ActivityCollection {

    /**
     * Empty activity collection.
     */
    ActivityCollection EMPTY = new ActivityCollection() {
        public Iterable<Activity> getActivities(int offset, int length) throws ActivityException {
            return Collections.emptyList();
        }
    };

    /**
     * Returns <code>length</code> activities of this stream, starting at <code>offset</code>.
     *
     * @param offset number of activities to skip
     * @param length number of activities to return. specifying a value &lt;= 0 returns all activities.
     * @return a collection of activities
     * @throws ActivityException if an error occurs.
     */
    Iterable<Activity> getActivities(int offset, int length) throws ActivityException;

}