/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2022 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * This interface is created in order to simplify Token Validation in the IMS bundle.
 *
 * Access token validation in IMS is defined and doesn't need the combination of multiple implementations
 * and the complexity of Dynamic Services like the TokenValidator OAuth interface proposes.
 *
 * Using the OfflineValidator allows to simplify this in the IMS bundle.
 */
@ConsumerType
public interface ExtendedTokenValidator extends TokenValidator{

    enum ValidationResult{
        NOT_EXPECTED_FORMAT,        // The token doesn't have the expected format. For example not a JWT when
                                    // a JWT is expected. It should be handled by a different authentication
                                    // handler.
        NOT_RECOGNIZED,             // The token has the expected format. For example, it is a JWT as expected
                                    // but it is not created by the expected IDP. It should be handled by a
                                    // different authentication handler.
        PUBLIC_KEY_NOT_AVAILABLE,   // The public key to validate the signature is not available
        SIGNATURE_FAIL,             // The token signature verification has failed
        NOT_EXPECTED_TYPE,          // The token is not the expected type of token (for example, it is a service token
                                    // when it is expected an access token).
        EXPIRED,                    // The token has expired
        FUTURE,                     // The token has been created in the future (system date problem)
        NOT_EXPECTED_ENVIRONMENT,   // The token is created for a different environment (prod, test, dev, etc...)
        VALID,                      // The token is valid, successful validation.
    }

    /**
     * Performs the complete token validation returning one of the possible results.
     *
     * It is a more nuanced implementation allowing for different behaviours to each error if needed.
     */
    @NotNull
    ValidationResult validate(@NotNull String token);
}
