/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.logging;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A recorded log entry by the {@link LogAnalyser}
 */
@ProviderType
public interface LogEntry {

    /**
     * The log level.
     * @return The log level
     */
    LogLevel getLogLevel();

    /**
     * The log message
     * @return The message
     */
    String getMessage();

    /**
     * The name of the logger (category)
     * @return The name of the logger (category)
     */
    String getLoggerName();

    /**
     * The time stamp of the log entry.
     * @return The time stamp of the log entry
     */
    long getTimeStamp();

    /**
     * Optional exception output attached to the log entry.
     * @return The exception stack trace or {@code null}
     */
    String getExceptionOutput();

    /**
     * The thread name of the logging thread.
     * @return The thread name of the logging thread
     */
    String getThreadName();
}
