/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.references;

import org.apache.sling.api.resource.Resource;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * A <code>Reference</code> represents a reference to the {@link Resource} backing the {@link ReferenceList}.
 * References can only be retrieved via a {@link ReferenceList}.
 * Each reference has a reference type.
 * The types available are defined by the {@link ReferenceProvider}s registered in the system and may vary.
 *
 * @since 1.0
 */
@ConsumerType
public class Reference {
    private final Resource source;
    private final Resource target;
    private final String type;

    public Reference(final Resource source, final Resource target, final String type) {
        this.source = source;
        this.target = target;
        this.type = type;
    }

    /**
     * Returns the source resource for which the references have been retrieved through the {@link ReferenceProvider}.
     *
     * @return The source resource.
     */
    public Resource getSource() {
        return source;
    }

    /**
     * Returns the target resource of the reference, i.e. one of the results retrieved by the {@link ReferenceProvider}.
     *
     * @return The target resource.
     */
    public Resource getTarget() {
        return target;
    }

    /**
     * Returns the reference type of this reference.
     *
     * @return The reference type.
     */
    public String getType() {
        return type;
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reference => {\n");
        sb.append("\tsource: ").append(getSource() != null ? getSource().getPath() : null).append("\n");
        sb.append("\ttarget: ").append(getTarget() != null ? getTarget().getPath() : null).append("\n");
        sb.append("\ttype: ").append(getType()).append("\n");
        sb.append("\tclass: ").append(getClass().getCanonicalName()).append("\n");
        sb.append("}\n");
        return sb.toString();
    }

}
