/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.socialgraph;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <code>SocialGraph</code> encapsulates an abstraction of a directed graph of node. A node in the graph is bound to a
 * user and the edges between the graph are established by relationships.
 * The <code>SocialGraph</code> is bound to a resource resolver and can be adapted from one.
 */
@ProviderType
public interface SocialGraph {

    /**
     * Returns the node for the given id.
     * Note that this method always returns a GraphNode for a valid social object, even if the persistent object for
     * the given id does not exist in the underlying system.
     *
     * @param id the id to retrieve the node for
     * @return the graph node or <code>null</code> of the social object with <code>id</code> does not exist.
     * @throws SocialGraphException if an error during this operation occurs.
     */
    GraphNode getNode(String id);

    /**
     * Saves the changes made to this social graph.
     * @throws SocialGraphException if an error during this operation occurs.
     */
    void save();

    /**
     * If <code>keepChanges</code> is <code>false</code>, this method discards
     * all pending changes currently recorded in this social graph and
     * reverts all items to reflect the current saved state.
     * <p>
     * If <code>keepChanges</code> is true then pending change are not discarded
     * but items that do not have changes pending have their state refreshed to
     * reflect the current saved state, thus revealing changes made by other
     * sessions.
     *
     * @param keepChanges a boolean
     * @throws SocialGraphException if an error during this operation occurs.
     */
    void refresh(boolean keepChanges);

}