/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.translation.connector.msft.core.ui.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.jackrabbit.JcrConstants;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MicrosoftCloudServiceUtils {

    private static final Logger logger = LoggerFactory.getLogger(MicrosoftCloudServiceUtils.class);

    // Constants used for generating hidden inputs
    private static final String COPY_FROM = "@CopyFrom";
    private static final String CQ_PAGE_TYPE = "cq:Page";
    private static final String SLING_FOLDER_TYPE = "sling:Folder";
    private static final String MERGE_LIST = "mergeList";

    // Constants used for manipulating cloud service paths and overlays
    private static final String CONF_HOME = "/conf";
    public static final String CLOUDSERVICE_CONF_PATH = "/conf/global/settings/cloudconfigs/translation";
    public static final String CLOUDSERVICE_LIBS_PATH = "/libs/settings/cloudconfigs/translation";

    // Helper for fetching properties from content node
    public static String getStringPropertyFromContent(Resource resource, String property) {
        try {
            if (resource != null) {
                Resource contentResource = resource.getChild(JcrConstants.JCR_CONTENT);
                Node content = contentResource.adaptTo(Node.class);
                if (content != null && content.hasProperty(property)) {
                    return content.getProperty(property).getString();
                }
            }
        } catch (RepositoryException e) {
            logger.error("Error fetching Property {} from {}", property, resource.getPath());
        }
        return "";
    }


    // Get the connector global properties, applicable on all credentials e.g. description, thumbnail
    public static String getConnectorProperty(ResourceResolver resourceResolver, String msConnectorPath,
        String propertyName) {
        // Base paths is the path below which all the credentials are present in the node
        String msConnectorBasePath = "";
        if (msConnectorPath.startsWith(CLOUDSERVICE_LIBS_PATH)) {
            msConnectorPath = msConnectorPath.substring(CLOUDSERVICE_LIBS_PATH.length() + 1);
            msConnectorBasePath = CLOUDSERVICE_LIBS_PATH + '/' + StringUtils.substringBefore(msConnectorPath, "/");
        } else if (msConnectorPath.startsWith(CONF_HOME)){
            msConnectorBasePath = Text.getRelativeParent(msConnectorPath, 1);
        }
        Resource msConnectorResource = resourceResolver.getResource(msConnectorBasePath);
        return getStringPropertyFromContent(msConnectorResource, propertyName);
    }


    // Helper for getting overlay paths and resources
    public static String getConfOverlayPath(String path) {
        if (path.startsWith(CONF_HOME)) {
            return path;
        } else if (path.startsWith(CLOUDSERVICE_LIBS_PATH)) {
            String overLayPath = CLOUDSERVICE_CONF_PATH;
            overLayPath = overLayPath + path.substring(CLOUDSERVICE_LIBS_PATH.length(), path.length());
            return overLayPath;
        }
        return "";
    }

    // Helper for getting the maps to replicate the libs structure in conf
    public static Map<String, String> getHiddenFields(SlingHttpServletRequest request) {
        Map<String, String> retVal = new LinkedHashMap<String, String>();
        String requestSuffix = request.getRequestPathInfo().getSuffix();
        String parentOfRequestSuffix = Text.getRelativeParent(requestSuffix, 1);
        String confOverLayPath = getConfOverlayPath(request.getRequestPathInfo().getSuffix());
        String parentConfOverLayPath = getConfOverlayPath(parentOfRequestSuffix);
        retVal.put(Text.getRelativeParent(parentConfOverLayPath, 2) + '/' + JcrConstants.JCR_PRIMARYTYPE,
                SLING_FOLDER_TYPE);
        retVal.put(Text.getRelativeParent(parentConfOverLayPath, 1) + '/' + JcrConstants.JCR_PRIMARYTYPE,
                SLING_FOLDER_TYPE);
        retVal.put(Text.getRelativeParent(parentConfOverLayPath, 1) + '/' + MERGE_LIST, "true");
        retVal.put(parentConfOverLayPath + '/' + JcrConstants.JCR_PRIMARYTYPE, CQ_PAGE_TYPE);
        retVal.put(parentConfOverLayPath + '/' + JcrConstants.JCR_CONTENT + COPY_FROM,
                parentOfRequestSuffix + '/' + JcrConstants.JCR_CONTENT);
        retVal.put(confOverLayPath + '/' + JcrConstants.JCR_PRIMARYTYPE, CQ_PAGE_TYPE);
        retVal.put(confOverLayPath+COPY_FROM, requestSuffix);
        return retVal;
    }

}
