/**************************************************************************
 *                                                                        *
 * ADOBE CONFIDENTIAL                                                     *
 * ___________________                                                    *
 *                                                                        *
 *  Copyright 2011 Adobe Systems Incorporated                             *
 *  All Rights Reserved.                                                  *
 *                                                                        *
 * NOTICE:  All information contained herein is, and remains              *
 * the property of Adobe Systems Incorporated and its suppliers,          *
 * if any.  The intellectual and technical concepts contained             *
 * herein are proprietary to Adobe Systems Incorporated and its           *
 * suppliers and are protected by trade secret or copyright law.          *
 * Dissemination of this information or reproduction of this material     *
 * is strictly forbidden unless prior written permission is obtained      *
 * from Adobe Systems Incorporated.                                       *
 **************************************************************************/
package com.adobe.versioncue.nativecomm.hook;

import java.io.IOException;

/**
 * Hook class for applying last-minute changes to the ncomm {@link ProcessBuilder}
 * before a new subprocess is spawned.
 *
 * @author tnaroska
 */
public interface IProcessLauncherHook
{
	/** No-op IProcessLauncherHook */
	static final IProcessLauncherHook NULL_HOOK = new IProcessLauncherHook()
	{
		public void beforeLaunch(ProcessBuilder pb) {}
		public void afterLaunch(Process p) {}
	};

	/**
	 * Called before a new process is spawned.
	 *
	 * @param pb - ProcessBuilder instance
	 * @throws IOException on error
	 */
	void beforeLaunch(ProcessBuilder pb) throws IOException;
	
	/**
	 * Called after a new process is spawned.
	 *
	 * @param p - Process instance
	 * @throws IOException on error
	 */
	void afterLaunch(Process p) throws IOException;
}
