/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;

import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;

/**
 * This class contains all the script functionality associated with the
 * XFAList class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ListBaseScript extends ObjScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ObjScript.moScriptTable,
		"list",
		new ScriptPropObj[] {
			new ScriptPropObj(ListBaseScript.class, "length", "getLength", null, Arg.INTEGER, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_LIST_LENGTH, 0*/, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(ListBaseScript.class, "item", "item", Arg.OBJECT,
				new int[] { Arg.INTEGER /*, XFA_IS_LIST_ITEM_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TREELIST_ITEM_DESC, XFA_IS_TREELIST_ITEM_RET, null*/, 0),
			new ScriptFuncObj(ListBaseScript.class, "append", "append", Arg.EMPTY,
				new int[] { Arg.OBJECT /*, XFA_IS_TREELIST_APPEND_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TREELIST_APPEND_DESC, 0*/, "appendPermsCheck", 0),
			new ScriptFuncObj(ListBaseScript.class, "remove", "remove", Arg.EMPTY,
				new int[] { Arg.OBJECT /*, XFA_IS_TREELIST_REMOVE_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TREELIST_REMOVE_DESC, 0*/, "removePermsCheck", 0),
			new ScriptFuncObj(ListBaseScript.class, "insert", "insert", Arg.EMPTY,
				new int[] { Arg.OBJECT, Arg.OBJECT /*, XFA_IS_TREELIST_INSERT_PARAM1, XFA_IS_TREELIST_INSERT_PARAM2*/ }, 2, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TREELIST_INSERT_DESC, 0*/, "insertPermsCheck", 0)
		}
	);

	/**
	 * static method used by the script interface for setting/getting properties
	 */
	public static void getLength(Obj pObj, Arg oRetVal) {
		int nArg = ((ListBase) pObj).length();
		oRetVal.setInteger(Integer.valueOf(nArg));
	}

	/**
	 * Static method for invoking functions in the script interface
	 */
	public static boolean appendPermsCheck(Obj obj, Arg[] args) {
		return ((ListBase) obj).appendPermsCheck();
	}

	public static boolean removePermsCheck(Obj obj, Arg[] args) {
		Obj oObject = args[0].getObject();
		if (!(oObject instanceof Node))
			throw new ExFull(ResId.ArgumentMismatchException);
		return ((ListBase) obj).removePermsCheck(oObject);
	}

	public static boolean insertPermsCheck(Obj obj, Arg[] args) {
		return ((ListBase) obj).insertPermsCheck();
	}

	public static void item(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		Obj oArg = null;
		int nArg = pArgs[0].getInteger().intValue();
		oArg = ((ListBase) pObj).item(nArg);
		oRetVal.setObject(oArg);
	}

	public static void append(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		// check the type
		Obj oObject = pArgs[0].getObject();
		((ListBase) pObj).append(oObject);
	}

	public static void remove(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		// check the type
		Obj oObject = pArgs[0].getObject();
		((ListBase) pObj).remove(oObject);
	}

	public static void insert(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		// check the type
		Obj oObject1 = pArgs[0].getObject();
		if (! (oObject1 instanceof Node))
			throw new ExFull(ResId.ArgumentMismatchException);
		// check the type
		Obj oObject2 = pArgs[1].getObject();
		if (! (oObject2 instanceof Node))
			throw new ExFull(ResId.ArgumentMismatchException);

		((ListBase) pObj).insert(oObject1, oObject2);
	}

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}
}
