package com.adobe.xfa;

/**
 * A base class for all transient scripting objects.
 * Transient objects represent objects that are available at runtime,
 * but are not represented by a corresponding XFA model.
 */
public abstract class PseudoModel extends Obj {
	/**
	 * list of events that this node is listening to
	 */
	private EventManager.EventTable mEventTable;
	
	private String maClassName;
	
	/**
	 * @exclude from published api.
	 */
	public PseudoModel() {
	}
	
	/**
	 * @exclude from published api.
	 */
	public Obj getAliasObject() {
		return this;
	}

	/**
	 * @exclude from published api.
	 */
	public EventManager.EventTable getEventTable(boolean bCreate) {
		if (bCreate && mEventTable == null) {
		    mEventTable = new EventManager.EventTable();
		}
		
		return mEventTable;
	}

	/**
	 * @exclude from published api.
	 */
	public ScriptTable getScriptTable() {
		return PseudoModelScript.getScriptTable();
	}

	/**
	 * Set the class name for this pseudo model
	 * @param aClassName the name of this class. This String must be interned.
	 * @exclude from published api.
	 */
	protected void setClass(String aClassName) {
		maClassName = aClassName;
	}

	/**
	 * @exclude from published api.
	 */
	public String getClassName() {
		return maClassName;
	}
}
