/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.ModelScript;

import com.adobe.xfa.Arg;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;


/**
 * This class contains all the script functionality associated with the
 * FormModel class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class FormModelScript extends ModelScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ModelScript.moScriptTable,
		"formModel",
		null,
		new ScriptFuncObj[] {
			new ScriptFuncObj(FormModelScript.class, "recalculate", "recalculate", Arg.EMPTY,
				new int[] { Arg.BOOL /*, XFA_IS_FORM_RECALCULATE_PARAM1 */}, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_FORM_RECALCULATE_DESC, 0, null */, 0),
			new ScriptFuncObj(FormModelScript.class, "execCalculate", "execCalculate", Arg.EMPTY,
				new int[] {}, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL /*, XFA_IS_FORM_RECALCULATE_DESC, 0, null */, 0),
			new ScriptFuncObj(FormModelScript.class, "execValidate", "execValidate", Arg.BOOL,
				new int[] {}, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL /*, XFA_IS_FORM_EXECVALIDATE_DESC, XFA_IS_FORM_EXECVALIDATE_RET, null */, 0),
			new ScriptFuncObj(FormModelScript.class, "execInitialize", "execInitialize", Arg.EMPTY,
				new int[] {}, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL /*, XFA_IS_FORM_EXECINITIALIZE_DESC, 0, null */, 0),
			new ScriptFuncObj(FormModelScript.class, "remerge", "remerge", Arg.EMPTY,
				new int[] {}, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_FORM_REMERGE_DESC, 0, null */, 0),
			new ScriptFuncObj(FormModelScript.class, "formNodes", "formNodes", Arg.OBJECT,
				new int[] { Arg.OBJECT /*, XFA_IS_FORM_FORMNODES_PARAM1 */ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_FORM_FORMNODES_DESC, XFA_IS_FORM_FORMNODES_RET, null */, 0),
			new ScriptFuncObj(FormModelScript.class, "metaData", "metaData", Arg.STRING,
				new int[] {}, 0, Schema.XFAVERSION_26, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_FORM_METADATA_DESC/*,XFA_IS_FORM_METADATASTRING_RET, null */, 0)
		}
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}
	
	
	public static void recalculate(Obj obj, Arg retVal, Arg[] args) {
		FormModel formModel = (FormModel)obj;
		FormModel.Validate validate = formModel.getDefaultValidate();
		formModel.recalculate(args[0].getBool().booleanValue(), validate, false);
	}

	public static void execCalculate(Obj obj, Arg retVal, Arg[] args) {
		FormModel formModel = (FormModel)obj;
		FormModel.Validate validate = formModel.getDefaultValidate();
		formModel.recalculate(true, validate, false);
	}
	
	public static void execValidate(Obj obj, Arg retVal, Arg[] args) {
		FormModel formModel = (FormModel)obj;
		FormModel.Validate validate = formModel.getDefaultValidate();
		
		formModel.validate(validate, null, true, false);
				
		if (validate != null && validate.getFailCount() > 0)
			retVal.setBool(Boolean.FALSE);
		else
			retVal.setBool(Boolean.TRUE);
	}

	public static void execInitialize(Obj obj, Arg retVal, Arg[] args) {
		((FormModel)obj).initialize();
	}

	public static void remerge(Obj obj, Arg retVal, Arg[] args) {
		 ((FormModel)obj).remerge();
	}

	public static void formNodes(Obj obj, Arg retVal, Arg[] args) {
		// Check the object type
		Obj object = args[0].getObject();
		if (!(object instanceof Node))
			throw new ExFull(ResId.ArgumentMismatchException);
	
		retVal.setObject(((FormModel)obj).getFormNodes((Node)object));
	}

	public static void metaData(Obj obj, Arg retVal, Arg[] args) {
		retVal.setString(((FormModel)obj).metaData(0));
	}
}
