/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.layout;


import com.adobe.xfa.AppModel;
//import com.adobe.xfa.layout.LayoutNode;

import com.adobe.xfa.template.TemplateModel;
//import com.adobe.xfa.template.containers.Subform;
//import com.adobe.xfa.template.containers.PageSet;
//import com.adobe.xfa.template.containers.PageArea;

//import com.adobe.xfa.ut.Storage;
//import com.adobe.xfa.ut.UnitSpan;


/**
 * This is the base class for the layout of an TemplateModel or FormModel
 *
 * Every xfalayout derivative represents a representation of a form, either based from
 * an underlying xfatemplatemodel or xfaformmodel. It is an array of trees structures, one for each
 * page in the final layout. Each tree hierarchy is comprised of xfalayoutnode derivatives, customized
 * for by layout implementation.
 * All layout classes are built using the same layout-building algorithm, and can perform specific operations
 * through various overridable functions.
 *
 * @exclude from published api.
 */
public class Layout {

	/**
	 * Constructor
	 */
	public Layout(AppModel oAppModel) {
		assert( oAppModel != null);
		moEnv = null;
		moAppModel = oAppModel;
//		moPageIterator = null;
		mbEndOfPagesException = false;
    }
	
	
//	/**
//	 * Perform a full or incremental layout as indicated.
//	 * @param bFullLayout true indicates a full layout is to be
//	 * performed. false indicates that an incremental layout is
//	 * to be attempted.
//	 */
	public void layout(boolean bFullRelayout /* = true */) {
		// JavaPort: TODO
	}

//	/**
//	 * Reset the layout
//	 * The layout is empty upon return (no pages)
//	 * This function allows the optional exception of any pooled resources that may be 
//	 * useful for a subsequent layout pass, ie between a failed incremental attempt
//	 * in preparation for a full layout. 
//	 * @param bClearPooledResources boolean to indicate whether to also reset any pooled resources
//	 * In general external classes should use reset() or reset(true)
//	 */
//	 public void reset(boolean bClearPooledResources /* = true */);
	
//	/**
//	 * Get the number of pages
//	 */
//	public int getPageCount() {
//		assert(moPageNodes.size() == moPageFronts.size());
//		return moPageNodes.size();
//	}

//	/**
//	 * Get the root node for given page
//	 * @param nPage zero based page index
//	 */
//	public LayoutNode getPageNode(int nPage);
	
//	/**
//	 * Get the xfapagearea node that corresponds to the given
//	 * page in layout
//	 * @param nPage zero based page index
//	 */
//	public PageArea	getPageAreaNode(int nPage);

//	/**
//	 * Return the index of the page the given node currently resides on.
//	 * @param oNode The node to search for
//	 * @param nIndex Upon return this contains the page index for the given node
//	 * @return true if the given node actually resides on a page in this layout, false otherwise.
//	 *  If node is not found on any page the value of nIndex is not set.
//	 */
//	public boolean getPageIndex(LayoutNode oNode, int nIndex);

//	/**
//	 * Add a page 
//	 * @param oPageLayoutNode root node of page
//	 * @param bFront true indicates the given page represents a front, false for back
//	 */
//	public void addPage(LayoutNode oPageLayoutNode, boolean bFront);		

//	/**
//	 * Remove the last page
//	 */
//	public void removeLastPage();

//	/**
//	 * Get the width/height dimensions of a given page
//	 */
//	public UnitSpan getPageWidth(int nPage);
//	public UnitSpan	getPageWidth(LayoutNode oPageLayoutNode);
//	public UnitSpan	getPageHeight(int nPage);
//	public UnitSpan	getPageHeight(LayoutNode oPageLayoutNode);

//	/**
//	 * Determine whether a page is marked for the front or back of a sheet.
//	 * @comment pages out range and orphaned pages will return false for both front and back
//	 */
//	public boolean isPageFront(int nIndex);
//	public boolean isPageFront(LayoutNode oNode);	
//	public boolean isPageBack(int nIndex);
//	public boolean isPageBack(LayoutNode oNode);

//	/**
//	 * Get the imposition setting to use for duplex pages.
//	 */
//	public Enum.VALUE getImposition();

//	/**
//	 * Given a layout node, return the root node for the page
//	 * that follows the page that the given node resides on.
//	 * @param oNode node on a given page to find next page from
//	 * @returns Root of next page, null if none
//	 */
//	public LayoutNode getNextPage(LayoutNode oNode);

//	/**
//	 * Given a layout node, return the layout node for the contentArea
//	 * that follows the contentArea that the given node resides on.
//	 * @param oNode node on a given contentArea to find next contentArea from
//	 * @returns Root of next page, null if none or if oNode is not in a contentArea,
//	 * such as page background
//	 */
//	public LayoutNode getNextContentArea(LayoutNode oNode);
	
	/**
	 * Return the layout environment
	 */
	public LayoutEnv getLayoutEnv() {
		assert(null != moEnv);
		return moEnv;
	}

	/**
	 * Return the app model
	 */
	public AppModel getAppModel() {
		return moAppModel;
	}

	/**
	 * Return the template model
	 */
	public TemplateModel getTemplateModel() {
		return TemplateModel.getTemplateModel(getAppModel(), false);
	}
	

//	/**
//	 * Return the page iterator
//	 */
//	public LayoutPageIterator getPageIterator() {
//		return moPageIterator;
//	}

//	/**
//	 * Returns true if the any aspect of the layout is currently damaged
//	 * and false otherwise.
//	 * @comments Recursively traverses all page hierarchies checking individual
//	 * designlayout nodes for layout damage. Returns on the first one found.
//	 */
//	public boolean isLayoutDamaged();

	/**
	 * Returns whether the previous layout process unexpectedly ran out or was
	 * unable to choose a page.
	 * Optionally return the pageSet from which we ran out
	 */
	public boolean ranOutOfPages() {
		return mbEndOfPagesException;
	}

//	public void ranOutOfPages(boolean bRanOut, PageSet oPageSet);

//	/**
//	 * Get the boolean value of a particular legacy setting
//	 * @param nLegacyFlag the specific legacy setting to check
//	 * @return true if the original version is less than nBoundary and if the specific legacy setting is enabled
//	 * @comment This is a convenience function that delegates to the template model
//	 */
//	public boolean getLegacySetting(int nLegacyFlag);

// Find all layout nodes associated with a given xfa node.
//	/**
//	 * Given an xfa node, return a list of the layout node existences (re: pieces) for that node
//	 * within the entire layout, if any.  This method iterates through all of the pages in the layout
//	 * @param oNode The xfa node to search for
//	 * @param oList Upon return this list contains all layoutnodes for the given node that exist in this layout (all pages)
//	 */
//	 public void getLayoutNodes(Node oNode, TreeList oList);

//Hit testing
//	/**
//	 * Given a point in document space, perform hit testing on 
//	 * given page of layout. A successful hit is defined as when the hit point
//	 * falls within a nominal extent of a layout node.
//	 * A list of successful 'hits' (if any) is returned through the oHitTest parameter 
//	 * @param nPage zero based index of page to perform hit testing on
//	 * @param oPt the coordinate in document space to test
//	 * @param oHitTest [in] object that contains parameters about scope of hit test
//	 * [out] object contains a list of the layout nodes that fell under the hit test point.
//	 * @return - true if at least one hit test success was found, and false otherwise.
//	 * If true is returned then oHitTest records the layout nodes that were 'hit'.                
//	 */
//	public boolean hitTest(int nPage, CoordPair oPt, LayoutHitTest oHitTest);
	
//	/**
//	 * Given a rectangle in document space, perform hit testing on given page
//	 * of layout. A successful hit is defined as when the nominal extent of a layoutnode
//	 * is completely enclosed within the given rectangle. A list of successfult 'hits'
//	 * (if any) is returned through the oHitTest parameter.
//	 * @param nPage zero based index of page to perform hit testing on
//	 * @param oRect a rectangle in document space to test against
//	 * @param oHitTest [in] object that contains parameters about scope of hit test
//	 * [out] object contains a list of the layout nodes that were successful 'hits'
//	 * @return - true if at least one hit test success was found, and false otherwise.
//	 * If true is returned then oHitTest records the layout nodes that were 'hit'.    
//	 *
//	 */
//	public boolean hitTest(int nPage, Rect oRect, LayoutHitTest oHitTest);	 	

//	/**
//	 * Static method to create a new instance (to be freed by caller) of the proper type
//	 * of page iterator, based on a collection of pageSets to be used.
//	 * @param The xfa pageSet to be used.  The "relation" attribute is examined.  A value
//	 * of "orderedOccurrence" will create an LayoutOccurrencePageIterator.  A value
//	 * of "simplexPaginated" or "duplexPaginated" will create a LayoutSimplexDuplexPageIterator
//	 * with the appropriate simplex/duplex flag.
//	 */ 
//	public static LayoutPageIterator newPageIterator(PageSet oPageSet);
	
//	/**
//	 * Return a page iterator, as per the xfalayout pagination model being used
//	 * @comments Can be overridden in cases that to return non standard page iterators
//	 * i.e. cases like DesignMasterPageLayout where standard pagination does not apply.
//	*/
//	public LayoutPageIterator createPageIterator();

//	/**
//	 * Get the boolean value of a particular non- processing instruction setting
//	 * @param nPILegacyFlag the specific non- processing instruction setting to check
//	 * @comment For a list of valid values for nPILegacyFlag, see the PI_... bit values
//	 * in xfaappmodel.h
//	 * @return true if the processing instruction setting was set to true
//	 */
//	public boolean getPILegacySetting (int nPILegacyFlag);

//
//Functions used by layout process
//
//	/**
//   * Create a new LayoutNodeNode and associate it with the g
//	 * given Node.
//	 * @param oNode xfanode for which this layout node applies
//	 * @return an LayoutNode.
//	 * @comment Node returned is orphaned, i.e. not a member of
//	 * any page hierarchy, nor does it have any children.
//	 * This allows individual xfalayouts to control the exact nodes
//	 * that are to be appended to the page hierarchies.
//	 */
//	virtual LayoutNode createNode(Node oNode);
//	virtual LayoutNode createNode(Node oNode, BoxModelLayout oBoxModel);
	
//	/**
//	 * Create and return the entire layout subhierarchy for a given node.
//	 * This returned layout tree represents the layout oNode and all it's children.
//	 * This is to provide an opportunity for xfalayouts to shortcut the regular layout building for this xfanode.
//	 * Returning null layout node will cause oNode layout to traversed layout created in the regular manner
//	 */
//	virtual LayoutNode createLayoutTree(Node oNode);
	
//	/**
//   * Query for the leader or trailer Subform with given id.
//	 * It is layout's responsibility to record occur information
//	 * and determine whether this is in fact the next leader/trailer
//	 * available.
//	 * @param sReference reference to the subform to use as the leader/trailer, either an ID or SOM expression
//	 * @param oParentNode parent context under which to create a leader/trailer
//	 * false indicates the bookend leader/trailer is required.
//	 * @param bPeek true if layout node is requested without modifying model
//	 * @return an LayoutNode.
//	 */
//	virtual Node getLeaderNode(String sReference, Node oParentNode, boolean bPeek);
//	virtual Node getTrailerNode(String sReference, Node oParentNode,  boolean bPeek);
	
//	/**
//	 * Notify the layout of a node that is relevant to layout
//	 * but is not directly present within the layout itself.
//	 * Such nodes are referred to as 'anonymous'
//	 * i.e. xfa nodes that don't have corresponding layout nodes
//	 * such as subformSets, pageSets
//	 */
//	virtual void notifyAnonymousNode(Node oNode);

//	/**
//	 * Notify the layout of a hidden node - hidden nodes are usually not
//	 * present within layout. This function can be overriden to perform 
//	 * some special processing unique to a specific layout.
//	 */
//	public void notifyHiddenNode(Node oNode);

//	/**
//	 * Notify the layout of a node that is deemed irrelevant
//	 * with respect to layout and it's not anonymous or hidden.
//	 * @comments Necessary since certain xfalayout derived classes
//	 * may actually be interested in these nodes.
//	 */
//	 public void notifyIgnoredNode(Node oNode);

//	 /**
//	 * Notify the layout of an embedded object and the container it is to be embedded in.
//	 */
//	 public void notifyEmbeddedObject(Node oEmbedContainer, Node oDependsOn);

//	 /**
//	 * Notify the layout that a new pageSet scope is to be begin. 
//	 * @comments Currently only relevant for subforms.
//	 */
//	 public void setPageSetScope(Node oNode);

//	 /**
//	 * Notify the layout that a pageSet scope may be coming to an end.
//	 * @comments Currently only relevant for subforms
//	 */
//	public void resetPageSetScope(Node oNode);

//	/**
//	 * Function that indicate if the given node
//	 * is 'layoutable', ie it represents an object that is eligible to exist within
//	 * the layout structure.
//	 * Supported objects are fields/draws/areas/subforms/exclgroups/subformsets
//	 * Objects that are hidden or anonymous are not considered 'layoutable'
//	 * Filters out some barcode obj types as written out by FF99 as well.
//	 */
//	public boolean isLayoutableObject(Node oNode);		

//	/**
//	 * Utility function thgat indicates whether a given node is
//	 * considered anonymous. That is, it affects layout but does
//	 * not have a direct presence within it (subformSets/pageSets)
//	 */
//	public boolean isAnonymousObject(Node oNode);

//	/**
//	 * Utility function that indicates whether a given node is
//	 * considered hidden/inactive. Such objects do not appear within layout
//	 * but may need further processing
//	 */
//	public boolean isHiddenObject(Node oNode);

//	/**
//	 * Utility function that indicates if a given node
//	 * is the type that can be split across content
//	 * areas and pages.
//	 */
//	public boolean isSplitableObject(Node oNode);

//	/**
//	 * Utility function that indicates whether the layout can be
//	 * proxied. A render proxyable layout is created when a text
//	 * cache is available.  To be render proxyable you must be a
//	 * draw, not splitable and be of fixed bounds, no embedded content and there will
//	 * need to be a cache present.	 
//	 */
//	public boolean isRenderProxyable(LayoutNode oNode, boolean bCheckRenderAs);

//	/**
//	 * Utility function that indicates whether the given xfanode contains render cache
//	 * information (i.e. renderCache processing instructions)
//	 * Such a node would have been deemed render-proxyable at design-save time
//	 * for this to have occurred.
//	 */
//	public boolean hasRenderProxyInfo(Node oNode);

//	/**
//	 * Helper functions to determine whether the given node has any break or keep elements.
//	 */
//	public boolean hasBreaks(Node oNode);
//	public boolean hasKeeps(Node oNode);
//	public boolean hasBreaksOrKeeps(Node oNode);
//	public boolean hasActiveKeep(Node oNode);

//	/**
//	 * Kick off a full layout given the starting subform and a collection
//	 * of pageAreas.
//	 */
//	protected virtual void layout(Subform oSubform);	

//	/**
//	 * Get the root subform to perform layout on
//	 * Returned subform represents the starting
//	 * point for layout.
//	 */
//	protected virtual Subform getRootSubform();

//	/**
//	 * Return the pageSet defined on the root subform to use during layout
//	 */
//	protected virtual PageSet getRootPageSet();	

//	/**
//	 * Called before any layout (full or incremental) begins
//	 */
//	protected void preLayout();

//	/**
//	 * Called after any layout (full or incremental) has completed.
//	 */
//	protected void postLayout();	

//	/**
//	 * Indicates whether a given layout supports incremental relayout
//	 * Returning true means an incremental relayout can be attempted
//	 * but does not advocate that it will be successful, in which case
//	 * the default behaviour is to then perform a full relayout.
//	 */
//	protected virtual boolean supportsIncrementalLayout();
	
//	/**
//	 * Called before an incremental layout is about to proceed.
//	 * @return true if incremental layout is to proceed and false
//	 * otherwise
//	 */
//	protected boolean preIncrementalLayout();	
	
//	/**
//	 * Kick off an incremental layout
//	 * @return true if incremental layout was successfully completed
//	 * and false otherwise.
//	 * @comment Failure in incremental relayout causes a full layout pass to occur
//	 */
//	protected boolean incrementalLayout();

//	/**
//	 * Called after an incremental layout has been attempted.
//	 * @param bIncrPassed true if the incremental layout was completed successfully, false
//	 * otherwise.
//	 */
//	protected void postIncrementalLayout(boolean bIncrPassed);

//	/**
//	 * Called before a full layout is about to proceed.
//	 */
//	protected void preFullLayout();

//	/**
//	 * Called after a successful full layout
//	 * has finished
//	 */
//	protected void postFullLayout();		
	
//	/**
//	 * Remove all pages - external users should use reset()
//	 */
//	protected void removeAllPages();		

//	/**
//	 * Traverses to and starts the inital page(s) of layout, as dictated by the root subform.
//	 * This obeys pageArea occurrences by fullfilling any minimums as it traverses to
//	 * specified initial page.  The default behaviour has the root subform begin on the 
//	 * first contentArea on the first pageArea.
//	 * @comments Note the act of starting the initial page could create >1 pages, depending on 
//	 * how they are defined in the pageset (boilerplate pages, occurrences etc)
//	 * Remember that pageSets are treated as an ordered list of pageAreas, with <occur min=0 max=-1/>
//	 * as default
//	 */
//	 protected void startInitialPage(Subform oRootSF, LayoutPageContext oPageContext);

//	/**
//	 * Traverse to and complete the final page(s) of layout, as dictated by the pageset
//	 * defined under the root subform. This means that the pageArea/pageSet mimumum occurrences
//	 * are fullfilled.
//	 * @comments Since default occur has min=0, the default behaviour of form layout is to end on the 
//	 * final page as dictated by the placement of content.
//	 */
//	 protected void completeFinalPage(Subform oRootSF, LayoutPageContext oPageContext);	 

//	 /**
//	  * Determines whether a node has any <setProperty> children which might be 
//	  * used to dynamically modify other properties of the node
//	  * @comments Currently checks only <draw> nodes as the only caller cares 
//	  * only about <draw> at this time.
//	  */
//	 protected boolean hasDynamicProperties(Node oNode);	

//	 /**
//	  * Return the first layoutable child of oParent.
//	  */
//	 protected Node getInitialFormContent(Node oParent);


//	 /**
//	  * Called when a layout has encountered an out-of-pages error.
//	  * Derived classes may override to perform any necessary actions.
//	  * @comments 'Out of page' errors will occur for a variety of reasons:
//	  * For occurrence page model it will occur when all instances of pageArea
//	  * occurrences have been spent. For the simplex/duplex page model the out-of-page
//	  * error occurs when no matching pageArea can be found that fullfills the current requirements
//	  * (back/front/blank/non-blank etc)
//	  */
//	 public void ranOutOfPagesError(ExFull oEx, LayoutPageContext oPageContext);	 

//	 /**
//	 * Given an xfa node, and an xfa layout node, recursively iterate through the layout nodes children and
//	 * return a list of the layout node existences (re: pieces) for that xfa node within the entire layout, if any.
//	 * @param oNode The xfa node to search for
//	 * @param oLNode The xfa layout node to search through
//	 * @param oList Upon return this list contains all layoutnodes for the given node that exist in this layout (all pages)
//	 */
//	public void getLayoutNodes(Node oNode, LayoutNode oLNode, TreeList oList);

//for derived classes only
	
	/**
	 * Set layout environment. Will be deleted upon destruction 
	 */
	protected void setLayoutEnv(LayoutEnv oEnv) {
		moEnv = oEnv;
	}

//	/*
//	 * recursive layout damage helper
//	 */
//	protected boolean isLayoutDamaged(LayoutNode oNode);		

//	//Iterator to determine next pageArea in sequence
//	protected LayoutPageIterator moPageIterator;	


//	//Derived classes should never access these lists directly. They are populated by adding pages.
//	private Storage<LayoutNode>	moPageNodes; 
//	private Storage<boolean> moPageFronts;

	//LayoutEnv class is used by the Text/Graphics packages to position, align, etc,
	//objects within the given environment. 
	//Also required to create the layout nodes.
	//It is imperative that moEnv does not go out of scope 
	//before the LayoutNodes.
	private LayoutEnv moEnv;
	
	//Application model
	private AppModel moAppModel;

	//Internal flag set when a layout unexpectedly runs out or is unable to choose a page
	private boolean	mbEndOfPagesException;

//	// Helper function to validate text run Processing Instructions for renderCache.
//	private boolean	verifyTextRunPIs(Node oNode);

//	/**
//	 * Given a layoutnode return a list of all pieces in existence, if any.  This method will also
//	 * add to the list, the original layout node passed in.
//	 * @param oNode The xfa layout node to get all of the pieces for
//	 * @param oList Upon return this list contains all layoutnodes for the given node that exist in this layout (all pages)
//	 */
//	private void addAllExistingLayoutNodes(LayoutNode oLayoutNode, TreeList oList);
//hide

//	private Layout(Layout oObj);
//	private Layout operator=(Layout right);

}
