/*************************************************************************
 *
 *	File: BarcodeEncoderFactory.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.common;

import com.adobe.xfa.pmp.adobepdf417pmp.PDF417Encoder;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixEncoder;
import com.adobe.xfa.pmp.qrcodepmp.QRCodeEncoder;

/**
 * Factory class for obtaining a Barcode encoder
 * 
 * @author shakumar
 */
public class BarcodeEncoderFactory {
	/**
	 * Gets an instance of a Barcode encoder based on the type supplied
	 * 
	 * @param type
	 *            barcode type
	 * @return barcode encoder
	 */
	public static BarcodeEncoder getEncoder(BarcodeType type) {
		BarcodeEncoder barcodeEncoder = null;
		switch (type) {
		case DataMatrix:
			barcodeEncoder = new DataMatrixEncoder();
			break;
		case PDF417:
			barcodeEncoder = new PDF417Encoder();
			break;
		case QRCode:
			barcodeEncoder = new QRCodeEncoder();
			break;
		}
		return barcodeEncoder;
	}
}
