package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

abstract class DispMapItem {
	private int mnIndex;
	private int mnLength;

	DispMapItem () {
	}

	DispMapItem (DispMapItem oSource) {
		this (oSource.mnIndex, oSource.mnLength);
	}

	DispMapItem (int nIndex, int nLength) {
		mnIndex = nIndex;
		mnLength = nLength;
	}

	int getMapIndex () {
		return mnIndex;
	}

	void setMapIndex (int nIndex) {
		mnIndex = nIndex;
	}

	int getMapLength () {
		return mnLength;
	}

	void setMapLength (int nLength) {
		mnLength = nLength;
	}

	DispEmbed e () {
		assert (false);
		return null;
	}

	GlyphLoc g () {
		assert (false);
		return null;
	}

	DispPosn p () {
		assert (false);
		return null;
	}

	TextPosn pp () {
		assert (false);
		return null;
	}

	DispRun r () {
		assert (false);
		return null;
	}

	void add (DispLine line, int start, int length) {
		assert (false);
	}

	DispMapItem cloneMapItem () {
		assert (false);
		return null;
	}

	abstract DispMapItem cloneMapItem (int start, int length);

	void copyFrom (DispMapItem source) {
		mnIndex = source.mnIndex;
		mnLength = source.mnLength;
	}
}

class DispMapSpan {
	private DispLine mpoLine;
	private DispMapItem moItem;
	private int mnStart;

	DispMapSpan (DispLine poLine) {
		mpoLine = poLine;
	}

	DispMapSpan (DispLine poLine, DispMapItem oSource) {
		mpoLine = poLine;
		moItem = oSource.cloneMapItem();
	}

	DispLine getLine () {
		return mpoLine;
	}

	int length () {
		return mpoLine.getCharCount() - mnStart;
	}

	void flush (boolean bForce) {
		int nLength = length();
		if ((nLength > 0) || bForce) {
			assert (moItem != null);
			moItem.add (mpoLine, mnStart, nLength);
			mnStart = mpoLine.getCharCount();
		}
	}
	void flush () {
		flush (false);
	}

	void reset (DispMapItem oSource, boolean bForce) {	// TODO: may be able to take ownership of given item
		flush (bForce);
		if (moItem == null) {
			moItem = oSource.cloneMapItem();
		} else {
			moItem.copyFrom (oSource);
		}
	}
	void reset (DispMapItem oSource) {
		reset (oSource, false);
	}

	DispPosn p () {
		assert (moItem instanceof DispPosn);
		return (DispPosn) moItem;
	}

	TextPosn pp () {
		assert (moItem instanceof DispPosn);
		DispPosn p = (DispPosn) moItem;
		return p.pp();
	}

	DispRun r () {
		assert (moItem instanceof DispRun);
		return (DispRun) moItem;
	}

	void copyFrom (DispMapItem source) {
		if (moItem == null) {
			moItem = source.cloneMapItem();
		} else {
			moItem.copyFrom (source);
		}
	}
}
