package com.adobe.xfa.text;

import java.util.List;

import com.adobe.xfa.text.markup.MarkupOut;

/**
 * @exclude from published api.
 */

class StrEmbed extends StrItem {

	private final TextEmbed mpoEmbed;

	StrEmbed (TextEmbed poNewEmbed, int eLevel) {
		super (TextItem.OBJECT);
		mpoEmbed = poNewEmbed.cloneEmbed();
		mpoEmbed.setLegacyLevel (eLevel);
	}

	StrEmbed (TextEmbed poNewEmbed, TextGfxSource oGfxSource) {
		super (TextItem.OBJECT);
		mpoEmbed = poNewEmbed.cloneEmbed();
		mpoEmbed.gfxSource (oGfxSource);
	}

//	void finalize () {
//		if (mpoEmbed != null) {		// TODO: need proper StrItem detach mechanism (or is this even an issue?)
//			TextPosn oDetachedPosn; // Detach object's posn ...
//			mpoEmbed.Position (oDetachedPosn); // ... from text stream
//		}
//	}

	void addEmbed (List<TextEmbed> oEmbeds) {
		oEmbeds.add (mpoEmbed);
	}

	TextAttr markup (MarkupOut oMarkup, int nStart, int nSize, boolean bFlattenFields, TextAttr poPrevAttr) {
		oMarkup.embed (mpoEmbed);
		return poPrevAttr;
	}

	TextEmbed embedAt (int nIndex) {
		return mpoEmbed;
	}

	boolean isEqual (StrItem poCompare) {
		if (! (poCompare instanceof StrEmbed)) {
			return false;
		}
		StrEmbed poEmbedItem = (StrEmbed) poCompare;
		TextEmbed poCompareEmbed = poEmbedItem.mpoEmbed;

		if ((mpoEmbed == null) || (poCompareEmbed == null)) {
			return mpoEmbed == poCompareEmbed;
		}

//		if (mpoEmbed.Type() != poCompareEmbed.Type()) {
//			return false;
//		}

		return mpoEmbed.isEqual (poCompareEmbed);
	}

	StrItem cloneItem (TextGfxSource oGfxSource) {
		return new StrEmbed (mpoEmbed, oGfxSource);
	}

	void gfxSource (TextGfxSource oGfxSource) {
		if (mpoEmbed != null) {
			mpoEmbed.gfxSource (oGfxSource);
		}
	}

	void cascadeLegacyLevel (int eLevel) {
		if (mpoEmbed != null) {
			mpoEmbed.setLegacyLevel (eLevel);
		}
	}

	void debug (int indent) {
		System.out.println (Pkg.doIndent (indent+1) + "Embed");
	}
}
