/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

/**
 * A class to represents the elements the {@link ExFull} class.
 * <p>
 * Objects of this class are error messages, consisting of an associated
 * resource property and an error message text property.
 * <p>
 * Objects of this class are considered resolved whenever its error message text
 * property has been loaded.
 *
 * @exclude from published api.
 */

public class ExErrItem {
	private boolean mbResolved; // the resolved state.

	private Object moFormat; // points to either a MsgFormat or MsgFormatPos object

	private int mResId; // the resource property.

	private String msText; // the error message text property.

	/**
	 * Instantiate a ExErrItem object -- the default c'tor.
	 */
	public ExErrItem() {
//		mResId = 0;
//		mbResolved = false;
//		moFormat = null;
	}

	/**
	 * Instantiate a ExErrItem object -- the copy c'tor.
	 */
	public ExErrItem(ExErrItem oSource) {
		msText = oSource.msText;
		mResId = oSource.mResId;
		moFormat = oSource.moFormat;
		mbResolved = oSource.mbResolved;
	}

	/**
	 * Instantiate a ExErrItem object -- the ResId c'tor.
	 * 
	 * @param nNewResId -
	 *            set this object's resource property to the given resource.
	 */
	public ExErrItem(int nNewResId) {
		mResId = nNewResId;
//		mbResolved = false;
//		moFormat = null;
	}

	/**
	 * Instantiate a ExErrItem object -- the ResId, String c'tor.
	 * 
	 * @param nNewResId -
	 *            set this object's resource property to the given resource.
	 * @param sNewText -
	 *            set this object's error message text property to the string
	 *            provided. The ructed object is considered resolved.
	 */
	public ExErrItem(int nNewResId, String sNewText) {
		mResId = nNewResId;
		msText = sNewText;
		mbResolved = true;
//		moFormat = null;
	}

	void formatObject(Object oFormat) {
		moFormat = oFormat;
	}

	/**
	 * Reference the <i>nIndex</i>'th Format string in this object's
	 * collection.
	 * 
	 * @param nIndex -
	 *            the index of Format string to return. Must be in the range 0
	 *            to getParamCount() - 1.
	 * @return the <i>nIndex</i>'th parameter object.
	 */
	String getParm(int nIndex) {
		if (moFormat == null)
			return "";

		if (moFormat instanceof MsgFormat) {
			MsgFormat m = (MsgFormat) moFormat;
			return m.getParm(nIndex);
		}
		if (moFormat instanceof MsgFormatPos) {
			MsgFormatPos mp = (MsgFormatPos) moFormat;
			return mp.getParm(nIndex);
		}
		return "";
	}

	/**
	 * Get the number of parameters in this ExErrItem
	 */
	int getParmCount() {
		if (moFormat instanceof MsgFormat) {
			MsgFormat m = (MsgFormat) moFormat;
			return m.getParmCount();
		}
		if (moFormat instanceof MsgFormatPos) {
			MsgFormatPos mp = (MsgFormatPos) moFormat;
			return mp.getParmCount();
		}
		return 0;
	}

	/**
	 * Get this object's resource property.
	 * 
	 * @return the ResId property.
	 */
	public int resId() {
		return mResId;
	}

	/**
	 * Set this object's resource property to the given resource.
	 * 
	 * @param nNewResId -
	 *            the new resource property.
	 */
	public void resId(int nNewResId) {
		mResId = nNewResId;
	}

	/**
	 * Resolve (load) the resource text associated with this object's resource
	 * property to this object's error message text property, if not already
	 * resolved.
	 */
	public void resolve() {
		if (!mbResolved) {
			msText = ResourceLoader.loadResource(mResId);
			mbResolved = msText != null;
		}
	}

	/**
	 * Get this object's error message text property.
	 * 
	 * @return the error message text property.
	 */
	public String text() {
		return msText;
	}

	/**
	 * Set this object's error message text property to the given string.
	 * 
	 * @param sNewText -
	 *            the new error message text property.
	 */
	public void text(String sNewText) {
		msText = sNewText;
		mbResolved = true;
	}

	public String toString() {
		resolve();
		return text();
	}
}
