// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import java.util.regex.Pattern;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;


/**
 * This rule represents a regular expression that has to match with the property value.
 * 
 * @author Stefan Makswit
 */
public class PatternRule implements TypeRule
{
	private static final long serialVersionUID = 1L;
	/** a regular expression as string */
	private String patternStr;
	/** the same regular expression compiled */
	private Pattern pattern;

	
	/**
	 * Constructs a new PatternRule.
	 *
	 * @param regexp the regular expression that describes the pattern.
	 */
	public PatternRule(String regexp)
	{
		this.patternStr = regexp;
		this.pattern = Pattern.compile(regexp);
	}
	
	
	/**
	 * @return Returns the pattern as Patter-object.
	 */
	public Pattern getPattern()
	{
		return pattern;
	}

	
	/**
	 * @return Returns the pattern a sString.
	 */
	public String getPatternStr()
	{
		return patternStr;
	}
	
	
	/**
	 * @see com.adobe.xmp.schema.model.TypeRule#accept(com.adobe.xmp.schema.model.SchemaVisitor)
	 */
	public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException
	{
		schemaVisitor.visit(this);
	}
}
