/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

/**
 * Service used to create diff output of texts and resources.
 */
public interface DiffService {

    /**
     * request parameter that specifies the version to diff to
     */
    public static final String REQUEST_PARAM_DIFF_TO = "cq_diffTo";

    /**
     * request parameter that can be used to transport a diff type
     */
    public static final String REQUEST_PARAM_DIFF_TYPE = "cq_diffType";

    /**
     * Compares two texts (plain text or rich text) and generates a rich
     * text containing <code>div</code> elements which mark added and removed
     * content.
     *
     * @param current the current text (right)
     * @param original the original text (left)
     * @param isRichText if <code>true</code> the text is considered rich, i.e.
     *        might contain HTML tags.
     * @return a rich text of the diff output
     */
    String diff(String current, String original, boolean isRichText);
}