/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.personalization.ui.groupedservicesselector;

import java.util.List;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Represents an interface for the GroupedServicesSelector component providing
 * methods used by the UI.
 */
@ProviderType
public interface GroupedServicesSelector {

    /**
     * Returns all available groups. The list of groups contains maps with the
     * following keys.
     * 
     * <pre>
     * <code> 
     * {
     *   title: 'My Group',
     *   description: 'Sample group',
     *   path: '/path/to/group',
     *   services: [{
     *     title: 'My service',
     *     description: 'Sample service',
     *     path: '/path/to/service'
     *   }]
     * }
     * </code>
     * </pre>
     * 
     * @return List of all available groups.
     */
    List<Map<String, Object>> getAllGroups();

    /**
     * Returns the groups/services which are stored in a property of the content
     * node of the current {@link com.day.cq.wcm.api.Page} resource. The list
     * of groups contains maps with the following keys.
     * 
     * <pre>
     * <code> 
     * {
     *   title: 'My Group',
     *   description: 'Sample group',
     *   path: '/path/to/group',
     *   inherited: false,
     *   services: [{
     *     title: 'My service',
     *     description: 'Sample service',
     *     path: '/path/to/service',
     *     selected: false
     *   }]
     * }
     * </code>
     * </pre>
     * 
     * @return List of groups for current page.
     */
    List<Map<String, Object>> getGroupsForResource();

    /**
     * Checks if the services are inherited.
     * 
     * @return {@code true} if services are inherited, {@code false} otherwise.
     */
    boolean isInherited();

    /**
     * Returns the path of the resource of type {@code cq:Page} from where the
     * services are inherited or {@code null} if values are not inherited.
     * 
     * @return Path of the inheritance source or {@code null}
     */
    String getInheritedPath();

    /**
     * Checks if the user bound to the current request is allowed to write the
     * property this widget is storing its state to. If the user is allowed to
     * write, {@code true} will be returned otherwise {@code false}.
     * 
     * @return {@code true} if user is allowed to write, {@code false}
     *         otherwise.
     */
    boolean isWriteAllowed();

}
