/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.util.Map;

import javax.jcr.Session;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * A ContentBuilder assembles the data for the replication.
 * A content handler needs to be registered with a {@link #PROPERTY_NAME}
 * service registration property.
 */
@ConsumerType
public interface ContentBuilder  {

    String PROPERTY_NAME = "name";

    /**
     * This parameter is set when the content builder is invoked by a replication agent.
     * It contains a {@link ReplicationContentFilterChain} to be used by {@link ContentBuilder}s to filter
     * content for exclusion from the replication content being built.
     * This parameter is optional and might be null.
     * @since 5.14
     */
    String PARAMETER_CONTENT_FILER_CHAIN = ContentBuilder.class.getName() + "/ReplicationContentFilterChain";

    /**
     * Create the replication content.
     * If this content builder does not create content for the actual replication
     * (e.g. for a delete replication), the content builder should return
     * {@link ReplicationContent#VOID}.
     *
     * @param session session to use to access the repository
     * @param action The replication action.
     * @param contentFactory the factory for creating binary content objects.
     * @return A newly created replication content or {@link ReplicationContent#VOID}.
     *
     * @throws ReplicationException if an error during assembly of the content occurs.
     */
    ReplicationContent create(Session session, ReplicationAction action, ReplicationContentFactory contentFactory)
	    throws ReplicationException;

    /**
     * Create the replication content.
     * If this content builder does not create content for the actual replication
     * (e.g. for a delete replication), the content builder should return
     * {@link ReplicationContent#VOID}.
     *
     * @param session session to use to access the repository
     * @param action The replication action.
     * @param contentFactory the factory for creating binary content objects.
     * @param parameters additional parameters needed for implementation specific purposes
     * @return A newly created replication content or {@link ReplicationContent#VOID}.
     *
     * @throws ReplicationException if an error during assembly of the content occurs.
     */
    ReplicationContent create(Session session, ReplicationAction action, ReplicationContentFactory contentFactory,
                              Map<String, Object> parameters)
            throws ReplicationException;

    /**
     * Returns the name of this content builder.
     * @return the name of this content builder.
     * @since 5.3
     */
    String getName();

    /**
     * Returns the title of this content builder.
     * @return the title.
     * @since 5.3
     */
    String getTitle();
}