/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

/**
 * The type of the replication action.
 */
public enum ReplicationActionType {

    /**
     * Content is activated
     */
    ACTIVATE("Activate"),

    /**
     * Content is deactivated
     */
    DEACTIVATE("Deactivate"),

    /**
     * Content is deleted
     */
    DELETE("Delete"),

    /**
     * Test replication
     */
    TEST("Test"),

    /**
     * Content is polled by reverse replication. Only used internally.
     *
     * @deprecated since 5.5. use {@link #INTERNAL_POLL} instead.
     */
    @Deprecated
    REVERSE("Reverse"),

    /**
     * Content is polled by reverse replication. Only used internally.
     *
     * @since 5.5
     */
    INTERNAL_POLL("Internal Poll");

    /**
     * internal human readable name
     */
    private final String name;

    /**
     * Create a type
     *
     * @param name name
     */
    private ReplicationActionType(String name) {
        this.name = name;
    }

    /**
     * Returns the human readable type name of this type.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Creates an action type for the given name. if the name cannot be mapped
     * to a enum type or if it's <code>null</code>, <code>null</code> is
     * returned.
     *
     * @param n the name
     * @return the type or <code>null</code>
     */
    public static ReplicationActionType fromName(String n) {
        if (n == null) {
            return null;
        }
        try {
            return ReplicationActionType.valueOf(n.toUpperCase());
        } catch (IllegalArgumentException e) {
            return null;
        }
    }
}
