/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting.helpers;

/**
 * This enumeration defines avaiable data types that are supported by the client for
 * displaying.
 */
public enum DisplayDataType {

    /**
     * numeric data
     */
    NUMBER("number"),

    /**
     * integer numeric data
     */
    INT("int"),

    /**
     * textual data
     */
    STRING("string"),

    /**
     * date
     */
    DATE("date"),

    /**
     * list
     */
    LIST("list"),

    /**
     * custom
     */
    CUSTOM("custom");


    /**
     * Textual representation of the data type
     */
    private String strRep;


    /**
     * Creates a new aggregated data type.
     *
     * @param strRep The string representation of the data type
     */
    private DisplayDataType(String strRep) {
        this.strRep = strRep;
    }

    /**
     * Creates a suitable string representation of the enumeration value.
     *
     * @return The string representation
     */
    public String toString() {
        return this.strRep;
    }

}
