/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;

import java.net.UnknownServiceException;
import java.net.URISyntaxException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.io.IOException;

/**
 * Service that validates external links.
 */
public interface ExternalLinkChecker {

    /**
     * Checks the given uri.
     * @param uri the uri to check
     * @return the http status response
     * @throws UnknownServiceException if the protocol is not supported
     * @throws URISyntaxException if the uri is malformed
     * @throws ConnectException if the connect failed
     * @throws NoRouteToHostException if there is no route to the host
     * @throws UnknownHostException if the host is unknown
     * @throws IOException if a general I/O error occured
     */
    int check(String uri) throws UnknownServiceException, URISyntaxException,
            ConnectException, NoRouteToHostException, UnknownHostException, IOException;

    /**
     * Walks through the links stored in the repository and checks them for validity
     * if necessary or removes them from the repository if they are no longer used.
     */
    void checkLinks();

    /**
     * Checks the given link store in the repository and checks it for validity.
     *
     * @param link link to check
     * @param force if <code>true</code> force a re-check
     * @return the updated link info or <code>null</code> if it was removed.
     */
    LinkInfo checkLink(String link, boolean force);
}
