/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.suggest;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import aQute.bnd.annotation.ProviderType;

/**
 * Service interface for managing {@link SuggestionIndex}es, e.g. reading,
 * creating and deleting them.
 */
@ProviderType
public interface SuggestionIndexManager {

    /**
     * Gets or creates a suggestion index. The index will be created on demand
     * when the first term is added.
     *
     * <p>
     * <b>Note:</b> make sure to {@link SuggestionIndex#close() close} the index
     * after usage to properly release affected resources, e.g. the underlying
     * JCR session. This should be done in a try/finally block.
     *
     * <p>
     * The returned index is not thread-safe.
     *
     * @param session
     *            session for reading (or writing) the index
     * @param name
     *            name or path of the index
     * @return a suggestion index
     * @throws RepositoryException
     *             if an unexpected repository problem occurred
     */
    SuggestionIndex get(Session session, String name) throws RepositoryException;

    /**
     * Lists the available suggestions indexes.
     *
     * <p>
     * If the indexes were created with path names in {@link #get(String)},
     * these will always be returned as relative paths, ie. without a leading
     * slash. Both variants, "/index" and "index" will work with
     * {@link #get(String)} and {@link #delete(String)}.
     *
     * @param session
     *          session for listing the indexes
     * @return a list of index names (relative paths)
     * @throws RepositoryException
     *             if an unexpected repository problem occurred
     */
    Iterable<String> list(Session session) throws RepositoryException;

    /**
     * @deprecated use the variant with a session: {@link #get(Session, String)}
     */
    @Deprecated
    SuggestionIndex get(String name) throws RepositoryException;

    /**
     * @deprecated use {@code get(session, name).delete()}
     */
    @Deprecated
    void delete(String name) throws RepositoryException;

    /**
     * @deprecated use the variant with a session: {@link #list(Session)}
     */
    @Deprecated
    Iterable<String> list() throws RepositoryException;
}
