/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.wcm.core.utils;

import java.util.Locale;

/**
 * The <code>PageNameValidatorService</code> handles the validation and creation of valid jcr name
 * out of any given arbitrary string.
 */
public interface PageNameValidatorService {

    /**
     * Non-valid name characters.
     */
    String NON_VALID_CHARS = "%/\\:*?\"[]|\n\t\r. ";

    /**
     * Create a valid label out of an arbitrary string with a custom character
     * mapping.
     *
     * @param name                        name to be converted to valid form
     * @param locale                      the locale whose conversion rules are to be used
     * @param defaultReplacementCharacter the default character to use for characters not mapped in the service table
     * @return a valid label string
     */
    String createValidName(String name, Locale locale, String defaultReplacementCharacter);

    /**
     * Checks if the name is not empty and contains only valid jcr chars.
     *
     * @param name the name to check
     * @return <code>true</code> if the name is valid
     */
    boolean isValidName(String name);
}
